/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.client.ddl;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.task.SQLTask;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.exception.MaxComputeTableOperationException;
import com.gotocompany.depot.maxcompute.schema.SchemaDifferenceUtils;
import com.gotocompany.depot.maxcompute.schema.validator.TableValidator;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import com.gotocompany.depot.utils.RetryUtils;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlManager {
    private static final Logger log = LoggerFactory.getLogger(DdlManager.class);
    private final Odps odps;
    private final MaxComputeSinkConfig maxComputeSinkConfig;
    private final Instrumentation instrumentation;
    private final MaxComputeMetrics maxComputeMetrics;
    private final TableValidator tableValidator;

    public DdlManager(Odps odps, MaxComputeSinkConfig maxComputeSinkConfig, Instrumentation instrumentation, MaxComputeMetrics maxComputeMetrics) {
        this.odps = odps;
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.instrumentation = instrumentation;
        this.maxComputeMetrics = maxComputeMetrics;
        this.tableValidator = new TableValidator(maxComputeSinkConfig);
    }

    public void createOrUpdateTable(TableSchema tableSchema) throws OdpsException {
        String projectName = this.maxComputeSinkConfig.getMaxComputeProjectId();
        String datasetName = this.maxComputeSinkConfig.getMaxComputeSchema();
        String tableName = this.maxComputeSinkConfig.getMaxComputeTableName();
        if (!this.odps.tables().exists(tableName)) {
            this.createTable(tableSchema, projectName, datasetName, tableName);
            return;
        }
        this.updateTable(tableSchema, projectName, datasetName, tableName);
    }

    private void createTable(TableSchema tableSchema, String projectName, String datasetName, String tableName) {
        log.info("Creating table: {} schema:{}", (Object)tableName, (Object)tableSchema);
        this.tableValidator.validate(tableName, this.maxComputeSinkConfig.getMaxComputeTableLifecycleDays(), tableSchema);
        RetryUtils.executeWithRetry(() -> {
            Instant start = Instant.now();
            this.odps.tables().newTableCreator(projectName, tableName, tableSchema).withSchemaName(datasetName).withLifeCycle(this.maxComputeSinkConfig.getMaxComputeTableLifecycleDays()).withTblProperties(this.maxComputeSinkConfig.getTableProperties()).create();
            this.instrumentation.logInfo("Successfully created maxCompute table " + tableName, new Object[0]);
            this.instrument(start, MaxComputeMetrics.MaxComputeAPIType.TABLE_CREATE);
        }, this.maxComputeSinkConfig.getMaxDdlRetryCount(), this.maxComputeSinkConfig.getDdlRetryBackoffMillis(), e -> e instanceof OdpsException);
    }

    private void updateTable(TableSchema tableSchema, String projectName, String datasetName, String tableName) {
        log.info("Updating table: {} schema:{}", (Object)tableName, (Object)tableSchema);
        Instant start = Instant.now();
        TableSchema oldSchema = this.odps.tables().get(projectName, datasetName, tableName).getSchema();
        this.checkPartitionPrecondition(oldSchema);
        LinkedList<String> schemaDifferenceSql = new LinkedList<String>(SchemaDifferenceUtils.getSchemaDifferenceSql(oldSchema, tableSchema, datasetName, tableName));
        RetryUtils.executeWithRetry(() -> {
            while (!schemaDifferenceSql.isEmpty()) {
                String sql = (String)schemaDifferenceSql.peekFirst();
                Instance instance = this.execute(sql);
                if (!instance.isSuccessful()) {
                    this.instrumentation.logError("Failed to execute SQL: " + sql, new Object[0]);
                    String errorMessage = ((Instance.InstanceResultModel.TaskResult)instance.getRawTaskResults().get(0)).getResult().getString();
                    throw new MaxComputeTableOperationException(String.format("Failed to update table schema with reason: %s", errorMessage));
                }
                schemaDifferenceSql.pollFirst();
            }
            this.instrumentation.logInfo("Successfully updated maxCompute table " + tableName, new Object[0]);
            this.instrument(start, MaxComputeMetrics.MaxComputeAPIType.TABLE_UPDATE);
        }, this.maxComputeSinkConfig.getMaxDdlRetryCount(), this.maxComputeSinkConfig.getDdlRetryBackoffMillis(), e -> e instanceof OdpsException);
    }

    private void checkPartitionPrecondition(TableSchema oldSchema) {
        if (this.maxComputeSinkConfig.isTablePartitioningEnabled().booleanValue() && oldSchema.getPartitionColumns().isEmpty()) {
            throw new MaxComputeTableOperationException("Updating non-partitioned table to partitioned table is not supported");
        }
        if (this.maxComputeSinkConfig.isTablePartitioningEnabled().booleanValue()) {
            String currentPartitionColumnKey = oldSchema.getPartitionColumns().stream().findFirst().map(Column::getName).orElse(null);
            if (!Objects.equals(this.maxComputeSinkConfig.getTablePartitionColumnName(), currentPartitionColumnKey)) {
                throw new MaxComputeTableOperationException("Changing partition column is not supported");
            }
        }
    }

    private Instance execute(String sql) throws OdpsException {
        log.info("Executing SQL: {}", (Object)sql);
        Instance instance = SQLTask.run((Odps)this.odps, (String)sql);
        instance.waitForSuccess();
        return instance;
    }

    private void instrument(Instant startTime, MaxComputeMetrics.MaxComputeAPIType type) {
        this.instrumentation.incrementCounter(this.maxComputeMetrics.getMaxComputeOperationTotalMetric(), String.format("table=%s", this.maxComputeSinkConfig.getMaxComputeTableName()), String.format("project=%s", this.maxComputeSinkConfig.getMaxComputeProjectId()), String.format("api=%s", new Object[]{type}));
        this.instrumentation.captureDurationSince(this.maxComputeMetrics.getMaxComputeOperationLatencyMetric(), startTime, String.format("table=%s", this.maxComputeSinkConfig.getMaxComputeTableName()), String.format("project=%s", this.maxComputeSinkConfig.getMaxComputeProjectId()), String.format("api=%s", new Object[]{type}));
    }
}

