/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter;

import com.aliyun.odps.type.TypeInfo;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.converter.DurationProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.MessageProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.PrimitiveProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.ProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.StructProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.TimestampNTZProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.converter.TimestampProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.enumeration.MaxComputeTimestampDataType;
import com.gotocompany.depot.maxcompute.model.ProtoPayload;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class MaxComputeProtobufConverterCache {
    private static final String GOOGLE_PROTOBUF_TIMESTAMP = "google.protobuf.Timestamp";
    private static final String GOOGLE_PROTOBUF_DURATION = "google.protobuf.Duration";
    private static final String GOOGLE_PROTOBUF_STRUCT = "google.protobuf.Struct";
    private static final Set<Descriptors.FieldDescriptor.Type> SUPPORTED_PRIMITIVE_PROTO_TYPES = Sets.newHashSet((Object[])new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.BYTES, Descriptors.FieldDescriptor.Type.STRING, Descriptors.FieldDescriptor.Type.ENUM, Descriptors.FieldDescriptor.Type.DOUBLE, Descriptors.FieldDescriptor.Type.FLOAT, Descriptors.FieldDescriptor.Type.BOOL, Descriptors.FieldDescriptor.Type.INT64, Descriptors.FieldDescriptor.Type.INT32, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.UINT32, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.FIXED32, Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.SFIXED32, Descriptors.FieldDescriptor.Type.SINT64, Descriptors.FieldDescriptor.Type.SINT32});
    private final Map<String, ProtobufMaxComputeConverter> protobufMaxComputeConverterMap = new ConcurrentHashMap<String, ProtobufMaxComputeConverter>();
    private final Map<String, TypeInfo> typeInfoCache = new ConcurrentHashMap<String, TypeInfo>();

    public MaxComputeProtobufConverterCache(MaxComputeSinkConfig maxComputeSinkConfig) {
        PrimitiveProtobufMaxComputeConverter primitiveProtobufMaxComputeConverter = new PrimitiveProtobufMaxComputeConverter(maxComputeSinkConfig);
        SUPPORTED_PRIMITIVE_PROTO_TYPES.forEach(type -> this.protobufMaxComputeConverterMap.put(type.toString(), primitiveProtobufMaxComputeConverter));
        if (maxComputeSinkConfig.getMaxComputeProtoTimestampToMaxcomputeType() == MaxComputeTimestampDataType.TIMESTAMP_NTZ) {
            this.protobufMaxComputeConverterMap.put(GOOGLE_PROTOBUF_TIMESTAMP, new TimestampNTZProtobufMaxComputeConverter(maxComputeSinkConfig));
        } else {
            this.protobufMaxComputeConverterMap.put(GOOGLE_PROTOBUF_TIMESTAMP, new TimestampProtobufMaxComputeConverter(maxComputeSinkConfig));
        }
        this.protobufMaxComputeConverterMap.put(GOOGLE_PROTOBUF_TIMESTAMP, MaxComputeTimestampDataType.TIMESTAMP_NTZ == maxComputeSinkConfig.getMaxComputeProtoTimestampToMaxcomputeType() ? new TimestampNTZProtobufMaxComputeConverter(maxComputeSinkConfig) : new TimestampProtobufMaxComputeConverter(maxComputeSinkConfig));
        this.protobufMaxComputeConverterMap.put(GOOGLE_PROTOBUF_DURATION, new DurationProtobufMaxComputeConverter());
        this.protobufMaxComputeConverterMap.put(GOOGLE_PROTOBUF_STRUCT, new StructProtobufMaxComputeConverter());
        this.protobufMaxComputeConverterMap.put(Descriptors.FieldDescriptor.Type.MESSAGE.toString(), new MessageProtobufMaxComputeConverter(this, maxComputeSinkConfig));
    }

    public TypeInfo getOrCreateTypeInfo(ProtoPayload protoPayload) {
        TypeInfo typeInfo = this.typeInfoCache.get(this.getTypeInfoCacheKey(protoPayload));
        if (Objects.isNull(typeInfo)) {
            ProtobufMaxComputeConverter protobufMaxComputeConverter = this.getConverter(protoPayload.getFieldDescriptor());
            typeInfo = protobufMaxComputeConverter.convertTypeInfo(protoPayload);
            this.typeInfoCache.put(protoPayload.getFieldDescriptor().getFullName(), typeInfo);
        }
        return typeInfo;
    }

    public TypeInfo getOrCreateTypeInfo(ProtoPayload protoPayload, Supplier<TypeInfo> supplier) {
        TypeInfo typeInfo = this.typeInfoCache.get(this.getTypeInfoCacheKey(protoPayload));
        if (Objects.isNull(typeInfo)) {
            typeInfo = supplier.get();
            this.typeInfoCache.put(protoPayload.getFieldDescriptor().getFullName(), typeInfo);
        }
        return typeInfo;
    }

    public ProtobufMaxComputeConverter getConverter(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            switch (fieldDescriptor.getMessageType().getFullName()) {
                case "google.protobuf.Timestamp": {
                    return this.protobufMaxComputeConverterMap.get(GOOGLE_PROTOBUF_TIMESTAMP);
                }
                case "google.protobuf.Duration": {
                    return this.protobufMaxComputeConverterMap.get(GOOGLE_PROTOBUF_DURATION);
                }
                case "google.protobuf.Struct": {
                    return this.protobufMaxComputeConverterMap.get(GOOGLE_PROTOBUF_STRUCT);
                }
            }
            return this.protobufMaxComputeConverterMap.get(Descriptors.FieldDescriptor.Type.MESSAGE.toString());
        }
        ProtobufMaxComputeConverter protobufMaxComputeConverter = this.protobufMaxComputeConverterMap.get(fieldDescriptor.getType().toString());
        if (protobufMaxComputeConverter == null) {
            throw new IllegalArgumentException("Unsupported type: " + fieldDescriptor.getType());
        }
        return protobufMaxComputeConverter;
    }

    private String getTypeInfoCacheKey(ProtoPayload protoPayload) {
        return String.format("%d_%s", protoPayload.getLevel(), protoPayload.getFieldDescriptor().getFullName());
    }

    public void clearCache() {
        this.typeInfoCache.clear();
    }
}

