/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter;

import com.aliyun.odps.data.ReorderableStruct;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.converter.MaxComputeProtobufConverterCache;
import com.gotocompany.depot.maxcompute.converter.ProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.model.ProtoPayload;
import com.gotocompany.depot.utils.ProtoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProtobufMaxComputeConverter
implements ProtobufMaxComputeConverter {
    private static final Logger log = LoggerFactory.getLogger(MessageProtobufMaxComputeConverter.class);
    private final MaxComputeProtobufConverterCache maxComputeProtobufConverterCache;
    private final int maxNestedMessageDepth;

    public MessageProtobufMaxComputeConverter(MaxComputeProtobufConverterCache maxComputeProtobufConverterCache, MaxComputeSinkConfig maxComputeSinkConfig) {
        this.maxComputeProtobufConverterCache = maxComputeProtobufConverterCache;
        if (maxComputeSinkConfig.getMaxNestedMessageDepth() < 1) {
            throw new IllegalArgumentException(String.format("Max nested message depth config (SINK_MAXCOMPUTE_PROTO_MAX_NESTED_MESSAGE_DEPTH) should be greater than 0. Current value: %d", maxComputeSinkConfig.getMaxNestedMessageDepth()));
        }
        this.maxNestedMessageDepth = maxComputeSinkConfig.getMaxNestedMessageDepth() - 1;
    }

    @Override
    public TypeInfo convertTypeInfo(ProtoPayload protoPayload) {
        return this.maxComputeProtobufConverterCache.getOrCreateTypeInfo(protoPayload, () -> ProtobufMaxComputeConverter.super.convertTypeInfo(protoPayload));
    }

    public StructTypeInfo convertSingularTypeInfo(ProtoPayload protoPayload) {
        List fieldNames = protoPayload.getFieldDescriptor().getMessageType().getFields().stream().filter(fd -> this.shouldIncludeField(protoPayload, (Descriptors.FieldDescriptor)fd)).map(Descriptors.FieldDescriptor::getName).collect(Collectors.toList());
        List typeInfos = protoPayload.getFieldDescriptor().getMessageType().getFields().stream().filter(fd -> this.shouldIncludeField(protoPayload, (Descriptors.FieldDescriptor)fd)).map(fd -> {
            ProtobufMaxComputeConverter converter = this.maxComputeProtobufConverterCache.getConverter((Descriptors.FieldDescriptor)fd);
            return converter.convertTypeInfo(new ProtoPayload((Descriptors.FieldDescriptor)fd, protoPayload.getLevel() + 1));
        }).collect(Collectors.toList());
        return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
    }

    @Override
    public Object convertSingularPayload(ProtoPayload protoPayload) {
        Message dynamicMessage = (Message)protoPayload.getParsedObject();
        ArrayList values = new ArrayList();
        protoPayload.getFieldDescriptor().getMessageType().getFields().stream().filter(fd -> this.shouldIncludeField(protoPayload, (Descriptors.FieldDescriptor)fd)).forEach(innerFieldDescriptor -> {
            if (dynamicMessage.getField(innerFieldDescriptor).toString().isEmpty()) {
                values.add(null);
                return;
            }
            if (ProtoUtils.isNonRepeatedProtoMessage(innerFieldDescriptor) && !dynamicMessage.hasField(innerFieldDescriptor)) {
                values.add(null);
                return;
            }
            if (ProtoUtils.isNonRepeatedString(innerFieldDescriptor) && !dynamicMessage.hasField(innerFieldDescriptor)) {
                values.add(null);
                return;
            }
            Object mappedInnerValue = this.maxComputeProtobufConverterCache.getConverter((Descriptors.FieldDescriptor)innerFieldDescriptor).convertPayload(new ProtoPayload((Descriptors.FieldDescriptor)innerFieldDescriptor, dynamicMessage.getField(innerFieldDescriptor), protoPayload.getLevel() + 1));
            values.add(mappedInnerValue);
        });
        TypeInfo typeInfo = this.convertTypeInfo(protoPayload);
        StructTypeInfo structTypeInfo = (StructTypeInfo)(typeInfo instanceof ArrayTypeInfo ? ((ArrayTypeInfo)typeInfo).getElementTypeInfo() : typeInfo);
        return new ReorderableStruct(structTypeInfo, values);
    }

    private boolean shouldIncludeField(ProtoPayload protoPayload, Descriptors.FieldDescriptor fd) {
        boolean shouldInclude;
        boolean bl = shouldInclude = protoPayload.getLevel() != this.maxNestedMessageDepth || fd.getType() != Descriptors.FieldDescriptor.Type.MESSAGE;
        if (!shouldInclude) {
            log.warn("Skipping field {} at level {} because it exceeds the max nested message depth", (Object)fd.getName(), (Object)protoPayload.getLevel());
        }
        return shouldInclude;
    }
}

