/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter.mapper.casted;

import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.exception.InvalidMessageException;
import com.gotocompany.depot.maxcompute.converter.mapper.ProtoPrimitiveDataTypeMapper;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;

public class FloatToDecimalDataTypeMapper
implements ProtoPrimitiveDataTypeMapper {
    private final int scale;
    private final int precision;
    private final RoundingMode roundingMode;

    public FloatToDecimalDataTypeMapper(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.scale = maxComputeSinkConfig.getProtoFloatToDecimalScale();
        this.precision = maxComputeSinkConfig.getProtoFloatToDecimalPrecision();
        this.roundingMode = maxComputeSinkConfig.getDecimalRoundingMode();
    }

    @Override
    public Map<Descriptors.FieldDescriptor.Type, TypeInfo> getProtoTypeMap() {
        return ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.Type.FLOAT, (Object)TypeInfoFactory.getDecimalTypeInfo((int)this.precision, (int)this.scale)).build();
    }

    @Override
    public Map<Descriptors.FieldDescriptor.Type, Function<Object, Object>> getProtoPayloadMapperMap() {
        return ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.Type.FLOAT, object -> this.isValid(((Float)object).floatValue())).build();
    }

    private BigDecimal isValid(float value) {
        if (!Float.isFinite(value)) {
            throw new InvalidMessageException("Invalid float value: " + value);
        }
        return new BigDecimal(Float.toString(value), new MathContext(this.precision)).setScale(this.scale, this.roundingMode);
    }
}

