/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.record;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ReorderableStruct;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.model.MaxComputeSchema;
import com.gotocompany.depot.maxcompute.model.RecordWrapper;
import com.gotocompany.depot.maxcompute.record.RecordDecorator;
import com.gotocompany.depot.maxcompute.schema.MaxComputeSchemaCache;
import com.gotocompany.depot.maxcompute.util.MetadataUtil;
import com.gotocompany.depot.message.Message;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ProtoMetadataColumnRecordDecorator
extends RecordDecorator {
    private final MaxComputeSchemaCache maxComputeSchemaCache;
    private final Map<String, String> metadataTypePairs;
    private final String maxcomputeMetadataNamespace;
    private final List<TupleString> metadataColumnsTypes;
    private final MetadataUtil metadataUtil;

    public ProtoMetadataColumnRecordDecorator(RecordDecorator recordDecorator, MaxComputeSinkConfig maxComputeSinkConfig, MaxComputeSchemaCache maxComputeSchemaCache, MetadataUtil metadataUtil) {
        super(recordDecorator);
        this.maxComputeSchemaCache = maxComputeSchemaCache;
        this.metadataUtil = metadataUtil;
        this.metadataTypePairs = maxComputeSinkConfig.getMetadataColumnsTypes().stream().collect(Collectors.toMap(TupleString::getFirst, TupleString::getSecond));
        this.maxcomputeMetadataNamespace = maxComputeSinkConfig.getMaxcomputeMetadataNamespace();
        this.metadataColumnsTypes = maxComputeSinkConfig.getMetadataColumnsTypes();
    }

    @Override
    public RecordWrapper process(RecordWrapper recordWrapper, Message message) throws IOException {
        if (StringUtils.isNotBlank((String)this.maxcomputeMetadataNamespace)) {
            this.appendNamespacedMetadata(recordWrapper.getRecord(), message);
        } else {
            this.appendMetadata(recordWrapper.getRecord(), message);
        }
        return new RecordWrapper(recordWrapper.getRecord(), recordWrapper.getIndex(), recordWrapper.getErrorInfo(), recordWrapper.getPartitionSpec());
    }

    private void appendNamespacedMetadata(Record record, Message message) {
        Map<String, Object> metadata = message.getMetadata(this.metadataColumnsTypes);
        MaxComputeSchema maxComputeSchema = this.maxComputeSchemaCache.getMaxComputeSchema();
        StructTypeInfo typeInfo = (StructTypeInfo)maxComputeSchema.getTableSchema().getColumn(this.maxcomputeMetadataNamespace).getTypeInfo();
        List values = IntStream.range(0, typeInfo.getFieldCount()).mapToObj(index -> {
            Object metadataValue = metadata.get(typeInfo.getFieldNames().get(index));
            return this.metadataUtil.getValidMetadataValue(this.metadataTypePairs.get(typeInfo.getFieldNames().get(index)), metadataValue);
        }).collect(Collectors.toList());
        record.set(this.maxcomputeMetadataNamespace, (Object)new ReorderableStruct(typeInfo, values));
    }

    private void appendMetadata(Record record, Message message) {
        Map<String, Object> metadata = message.getMetadata(this.metadataColumnsTypes);
        for (Map.Entry<String, TypeInfo> entry : this.maxComputeSchemaCache.getMaxComputeSchema().getMetadataColumns().entrySet()) {
            Object value = metadata.get(entry.getKey());
            record.set(entry.getKey(), this.metadataUtil.getValidMetadataValue(this.metadataTypePairs.get(entry.getKey()), value));
        }
    }
}

