/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.type.TypeInfo;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.converter.ProtobufConverterOrchestrator;
import com.gotocompany.depot.maxcompute.model.MaxComputeSchema;
import com.gotocompany.depot.maxcompute.model.ProtoPayload;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategy;
import com.gotocompany.depot.maxcompute.util.MetadataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MaxComputeSchemaBuilder {
    private final ProtobufConverterOrchestrator protobufConverterOrchestrator;
    private final MaxComputeSinkConfig maxComputeSinkConfig;
    private final PartitioningStrategy partitioningStrategy;
    private final MetadataUtil metadataUtil;

    public MaxComputeSchema build(Descriptors.Descriptor descriptor) {
        Column partitionColumn;
        List<Column> metadataColumns = this.buildMetadataColumns();
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder().withColumns(metadataColumns).withColumns(this.buildDataColumns(descriptor));
        Column column = partitionColumn = this.maxComputeSinkConfig.isTablePartitioningEnabled() != false ? this.buildPartitionColumn() : null;
        if (Objects.nonNull(partitionColumn)) {
            tableSchemaBuilder.withPartitionColumn(partitionColumn);
        }
        return new MaxComputeSchema(tableSchemaBuilder.build(), metadataColumns.stream().collect(Collectors.toMap(Column::getName, Column::getTypeInfo)));
    }

    private List<Column> buildDataColumns(Descriptors.Descriptor descriptor) {
        return descriptor.getFields().stream().filter(fieldDescriptor -> {
            if (!this.maxComputeSinkConfig.isTablePartitioningEnabled().booleanValue() || !fieldDescriptor.getName().equals(this.maxComputeSinkConfig.getTablePartitionKey())) {
                return true;
            }
            return !this.partitioningStrategy.shouldReplaceOriginalColumn();
        }).map(fieldDescriptor -> Column.newBuilder((String)fieldDescriptor.getName(), (TypeInfo)this.protobufConverterOrchestrator.toMaxComputeTypeInfo(new ProtoPayload((Descriptors.FieldDescriptor)fieldDescriptor))).build()).collect(Collectors.toList());
    }

    private Column buildPartitionColumn() {
        return this.partitioningStrategy.getPartitionColumn();
    }

    private List<Column> buildMetadataColumns() {
        if (!this.maxComputeSinkConfig.shouldAddMetadata()) {
            return new ArrayList<Column>();
        }
        if (StringUtils.isBlank((CharSequence)this.maxComputeSinkConfig.getMaxcomputeMetadataNamespace())) {
            return this.maxComputeSinkConfig.getMetadataColumnsTypes().stream().map(tuple -> Column.newBuilder((String)tuple.getFirst(), (TypeInfo)this.metadataUtil.getMetadataTypeInfo(tuple.getSecond())).build()).collect(Collectors.toList());
        }
        return Collections.singletonList(Column.newBuilder((String)this.maxComputeSinkConfig.getMaxcomputeMetadataNamespace(), (TypeInfo)this.metadataUtil.getMetadataTypeInfo(this.maxComputeSinkConfig.getMetadataColumnsTypes())).build());
    }

    public MaxComputeSchemaBuilder(ProtobufConverterOrchestrator protobufConverterOrchestrator, MaxComputeSinkConfig maxComputeSinkConfig, PartitioningStrategy partitioningStrategy, MetadataUtil metadataUtil) {
        this.protobufConverterOrchestrator = protobufConverterOrchestrator;
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.partitioningStrategy = partitioningStrategy;
        this.metadataUtil = metadataUtil;
    }
}

