/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema.partition;

import com.aliyun.odps.Column;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.type.TypeInfo;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategy;

public class DefaultPartitioningStrategy
implements PartitioningStrategy {
    private static final String PARTITION_SPEC_FORMAT = "%s=%s";
    private static final String DEFAULT_PARTITION = "__NULL__";
    private final TypeInfo typeInfo;
    private final MaxComputeSinkConfig maxComputeSinkConfig;

    @Override
    public String getOriginalPartitionColumnName() {
        return this.maxComputeSinkConfig.getTablePartitionKey();
    }

    @Override
    public boolean shouldReplaceOriginalColumn() {
        return true;
    }

    @Override
    public Column getPartitionColumn() {
        return Column.newBuilder((String)this.maxComputeSinkConfig.getTablePartitionColumnName(), (TypeInfo)this.typeInfo).build();
    }

    @Override
    public PartitionSpec getPartitionSpec(Object object) {
        if (object == null) {
            return new PartitionSpec(String.format(PARTITION_SPEC_FORMAT, this.maxComputeSinkConfig.getTablePartitionColumnName(), DEFAULT_PARTITION));
        }
        return new PartitionSpec(String.format(PARTITION_SPEC_FORMAT, this.maxComputeSinkConfig.getTablePartitionColumnName(), object));
    }

    public DefaultPartitioningStrategy(TypeInfo typeInfo, MaxComputeSinkConfig maxComputeSinkConfig) {
        this.typeInfo = typeInfo;
        this.maxComputeSinkConfig = maxComputeSinkConfig;
    }
}

