/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema.partition;

import com.aliyun.odps.Column;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.data.GenerateExpression;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.expression.TruncTime;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategy;

public class TimestampPartitioningStrategy
implements PartitioningStrategy {
    private final GenerateExpression generateExpression;
    private final String partitionColumnName;
    private final String partitionColumnKey;
    private final String tablePartitionByTimestampTimeUnit;

    public TimestampPartitioningStrategy(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.partitionColumnName = maxComputeSinkConfig.getTablePartitionColumnName();
        this.partitionColumnKey = maxComputeSinkConfig.getTablePartitionKey();
        this.tablePartitionByTimestampTimeUnit = maxComputeSinkConfig.getTablePartitionByTimestampTimeUnit();
        this.generateExpression = this.initializeGenerateExpression();
    }

    @Override
    public String getOriginalPartitionColumnName() {
        return this.partitionColumnKey;
    }

    @Override
    public boolean shouldReplaceOriginalColumn() {
        return false;
    }

    @Override
    public Column getPartitionColumn() {
        Column column = Column.newBuilder((String)this.partitionColumnName, (TypeInfo)TypeInfoFactory.STRING).build();
        column.setGenerateExpression((GenerateExpression)new TruncTime(this.partitionColumnKey, this.tablePartitionByTimestampTimeUnit));
        return column;
    }

    @Override
    public PartitionSpec getPartitionSpec(Object object) {
        PartitionSpec partitionSpec = new PartitionSpec();
        if (object instanceof Record) {
            Record record = (Record)object;
            partitionSpec.set(this.partitionColumnName, this.generateExpression.generate(record));
        }
        return partitionSpec;
    }

    private GenerateExpression initializeGenerateExpression() {
        return new TruncTime(this.partitionColumnKey, this.tablePartitionByTimestampTimeUnit);
    }
}

