/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.util;

import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.common.collect.ImmutableMap;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.enumeration.MaxComputeTimestampDataType;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MetadataUtil {
    private static final String TIMESTAMP = "timestamp";
    private static final String INTEGER = "integer";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private final Map<String, TypeInfo> metadataTypeMap;
    private final Map<String, Function<Object, Object>> metadataMapperMap;
    private final MaxComputeTimestampDataType maxComputeTimestampDataType;
    private final ZoneId zoneId;

    public MetadataUtil(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.maxComputeTimestampDataType = maxComputeSinkConfig.getMaxComputeProtoTimestampToMaxcomputeType();
        this.zoneId = maxComputeSinkConfig.getZoneId();
        this.metadataTypeMap = ImmutableMap.builder().put((Object)INTEGER, (Object)(maxComputeSinkConfig.isProtoIntegerTypesToBigintEnabled() ? TypeInfoFactory.BIGINT : TypeInfoFactory.INT)).put((Object)LONG, (Object)TypeInfoFactory.BIGINT).put((Object)FLOAT, (Object)TypeInfoFactory.FLOAT).put((Object)DOUBLE, (Object)TypeInfoFactory.DOUBLE).put((Object)STRING, (Object)TypeInfoFactory.STRING).put((Object)BOOLEAN, (Object)TypeInfoFactory.BOOLEAN).put((Object)TIMESTAMP, (Object)this.maxComputeTimestampDataType.getTypeInfo()).build();
        this.metadataMapperMap = ImmutableMap.builder().put((Object)INTEGER, obj -> {
            if (maxComputeSinkConfig.isProtoIntegerTypesToBigintEnabled()) {
                return ((Number)obj).longValue();
            }
            return ((Number)obj).intValue();
        }).put((Object)LONG, obj -> ((Number)obj).longValue()).put((Object)FLOAT, obj -> Float.valueOf(((Number)obj).floatValue())).put((Object)DOUBLE, obj -> ((Number)obj).doubleValue()).put((Object)STRING, Function.identity()).put((Object)BOOLEAN, Function.identity()).build();
    }

    public TypeInfo getMetadataTypeInfo(String type) {
        return this.metadataTypeMap.get(type.toLowerCase());
    }

    public Object getValidMetadataValue(String type, Object value) {
        if (TIMESTAMP.equalsIgnoreCase(type) && value instanceof Long) {
            return this.getTimestampValue((Long)value);
        }
        return this.metadataMapperMap.get(type.toLowerCase()).apply(value);
    }

    public StructTypeInfo getMetadataTypeInfo(List<TupleString> metadataColumnsTypes) {
        return TypeInfoFactory.getStructTypeInfo(metadataColumnsTypes.stream().map(TupleString::getFirst).collect(Collectors.toList()), metadataColumnsTypes.stream().map(tuple -> this.metadataTypeMap.get(tuple.getSecond().toLowerCase())).collect(Collectors.toList()));
    }

    private Object getTimestampValue(long value) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(value).atZone(this.zoneId).toLocalDateTime();
        if (MaxComputeTimestampDataType.TIMESTAMP_NTZ == this.maxComputeTimestampDataType) {
            return localDateTime;
        }
        return Timestamp.valueOf(localDateTime);
    }
}

