/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message;

import com.gotocompany.depot.common.Tuple;
import com.gotocompany.depot.common.TupleString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Message {
    private final Object logKey;
    private final Object logMessage;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public String getMetadataString() {
        return this.metadata.keySet().stream().map(key -> key + "=" + this.metadata.get(key)).collect(Collectors.joining(", ", "{", "}"));
    }

    @SafeVarargs
    public Message(Object logKey, Object logMessage, Tuple<String, Object> ... tuples) {
        this.logKey = logKey;
        this.logMessage = logMessage;
        Arrays.stream(tuples).forEach(t -> this.metadata.put((String)t.getFirst(), t.getSecond()));
    }

    public Map<String, Object> getMetadata(List<TupleString> metadataColumnsTypes) {
        return metadataColumnsTypes.stream().collect(Collectors.toMap(TupleString::getFirst, columnAndType -> this.metadata.get(columnAndType.getFirst())));
    }

    public Object getLogKey() {
        return this.logKey;
    }

    public Object getLogMessage() {
        return this.logMessage;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$logKey = this.getLogKey();
        Object other$logKey = other.getLogKey();
        if (this$logKey == null ? other$logKey != null : !this$logKey.equals(other$logKey)) {
            return false;
        }
        Object this$logMessage = this.getLogMessage();
        Object other$logMessage = other.getLogMessage();
        if (this$logMessage == null ? other$logMessage != null : !this$logMessage.equals(other$logMessage)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $logKey = this.getLogKey();
        result = result * 59 + ($logKey == null ? 43 : $logKey.hashCode());
        Object $logMessage = this.getLogMessage();
        result = result * 59 + ($logMessage == null ? 43 : $logMessage.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }
}

