/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message;

import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import java.io.IOException;

public class MessageContainer {
    private final Message message;
    private final MessageParser parser;
    private ParsedMessage parsedLogKey = null;
    private ParsedMessage parsedLogMessage = null;

    public MessageContainer(Message message, MessageParser parser) {
        this.message = message;
        this.parser = parser;
    }

    public ParsedMessage getParsedLogKey(String schemaProtoKeyClass) throws IOException {
        if (this.parsedLogKey == null) {
            this.parsedLogKey = this.parser.parse(this.message, SinkConnectorSchemaMessageMode.LOG_KEY, schemaProtoKeyClass);
        }
        return this.parsedLogKey;
    }

    public ParsedMessage getParsedLogMessage(String schemaProtoMessageClass) throws IOException {
        if (this.parsedLogMessage == null) {
            this.parsedLogMessage = this.parser.parse(this.message, SinkConnectorSchemaMessageMode.LOG_MESSAGE, schemaProtoMessageClass);
        }
        return this.parsedLogMessage;
    }

    public Message getMessage() {
        return this.message;
    }
}

