/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProtoField {
    private String name;
    private String typeName;
    private DescriptorProtos.FieldDescriptorProto.Type type;
    private DescriptorProtos.FieldDescriptorProto.Label label;
    private List<ProtoField> fields;
    private int index;

    public ProtoField() {
        this.fields = new ArrayList<ProtoField>();
    }

    public ProtoField(String name, String typeName, DescriptorProtos.FieldDescriptorProto.Type type, DescriptorProtos.FieldDescriptorProto.Label label, List<ProtoField> fields, int index) {
        this.name = name;
        this.typeName = typeName;
        this.type = type;
        this.label = label;
        this.fields = fields;
        this.index = index;
    }

    public ProtoField(DescriptorProtos.FieldDescriptorProto f) {
        this.name = f.getName();
        this.type = f.getType();
        this.label = f.getLabel();
        this.index = f.getNumber();
        this.fields = new ArrayList<ProtoField>();
        this.typeName = f.getTypeName();
    }

    public boolean isNested() {
        if (this.typeName != null && !this.typeName.equals("")) {
            return !this.typeName.equals(".google.protobuf.Timestamp") && !this.typeName.equals(".google.protobuf.Struct") && this.type == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE;
        }
        return this.type == DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE;
    }

    public void addField(ProtoField field) {
        this.fields.add(field);
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", type=" + this.type + ", len=" + this.fields.size() + ", nested=" + Arrays.toString(this.fields.toArray()) + '}';
    }

    public List<ProtoField> getFields() {
        return this.fields;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public DescriptorProtos.FieldDescriptorProto.Label getLabel() {
        return this.label;
    }

    public DescriptorProtos.FieldDescriptorProto.Type getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtoField)) {
            return false;
        }
        ProtoField other = (ProtoField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        DescriptorProtos.FieldDescriptorProto.Type this$type = this.getType();
        DescriptorProtos.FieldDescriptorProto.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        DescriptorProtos.FieldDescriptorProto.Label this$label = this.getLabel();
        DescriptorProtos.FieldDescriptorProto.Label other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<ProtoField> this$fields = this.getFields();
        List<ProtoField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtoField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        DescriptorProtos.FieldDescriptorProto.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        DescriptorProtos.FieldDescriptorProto.Label $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<ProtoField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        result = result * 59 + this.getIndex();
        return result;
    }
}

