/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.protobuf.Descriptors;
import com.gotocompany.depot.exception.ProtoNotFoundException;
import com.gotocompany.depot.message.proto.DescriptorCache;
import com.gotocompany.depot.message.proto.ProtoField;
import java.util.Map;

public class ProtoFieldParser {
    private static final int MAX_NESTED_SCHEMA_LEVEL = 15;
    private final DescriptorCache descriptorCache = new DescriptorCache();

    public ProtoField parseFields(ProtoField protoField, String protoSchema, Map<String, Descriptors.Descriptor> allDescriptors, Map<String, String> typeNameToPackageNameMap) {
        return this.parseFields(protoField, protoSchema, allDescriptors, typeNameToPackageNameMap, 1);
    }

    private ProtoField parseFields(ProtoField protoField, String protoSchema, Map<String, Descriptors.Descriptor> allDescriptors, Map<String, String> typeNameToPackageNameMap, int level) {
        Descriptors.Descriptor currentProto = this.descriptorCache.fetch(allDescriptors, typeNameToPackageNameMap, protoSchema);
        if (currentProto == null) {
            throw new ProtoNotFoundException("No Proto found for class " + protoSchema);
        }
        for (Descriptors.FieldDescriptor field : currentProto.getFields()) {
            ProtoField fieldModel = new ProtoField(field.toProto());
            if (fieldModel.isNested()) {
                if (protoSchema.substring(1).equals(currentProto.getFullName()) && level >= 15) continue;
                fieldModel = this.parseFields(fieldModel, field.toProto().getTypeName(), allDescriptors, typeNameToPackageNameMap, level + 1);
            }
            protoField.addField(fieldModel);
        }
        return protoField;
    }
}

