/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.message.LogicalValue;
import com.gotocompany.depot.schema.LogicalType;
import com.gotocompany.depot.schema.Schema;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class ProtoLogicalValue
implements LogicalValue {
    private final Message message;
    private final Schema schema;

    public ProtoLogicalValue(Message message, Schema schema) {
        this.message = message;
        this.schema = schema;
    }

    @Override
    public LogicalType getType() {
        return this.schema.logicalType();
    }

    @Override
    public Instant getTimestamp() {
        try {
            Timestamp timestamp = Timestamp.parseFrom((byte[])this.message.toByteArray());
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializerException(this.getErrMessage("Timestamp"), (Exception)((Object)e));
        }
    }

    private Object getValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case STRUCT_VALUE: {
                return this.getStructValue(value.getStructValue());
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().map(this::getValue).collect(Collectors.toList());
            }
        }
        return JSONObject.NULL;
    }

    private Map<String, Object> getStructValue(Struct s) {
        Map fieldsMap = s.getFieldsMap();
        return fieldsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getValue((Value)e.getValue())));
    }

    @Override
    public Map<String, Object> getStruct() {
        try {
            Struct s = Struct.parseFrom((byte[])this.message.toByteArray());
            return this.getStructValue(s);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializerException(this.getErrMessage("Struct"), (Exception)((Object)e));
        }
    }

    @Override
    public java.time.Duration getDuration() {
        try {
            Duration duration = Duration.parseFrom((byte[])this.message.toByteArray());
            return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializerException(this.getErrMessage("Duration"), (Exception)((Object)e));
        }
    }

    private String getErrMessage(String type) {
        return String.format("Failed while deserializing given \"%s\" to %s", this.message.getDescriptorForType().getFullName(), type);
    }
}

