/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.metrics;

import com.gotocompany.depot.metrics.StatsDReporter;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instrumentation
implements Closeable {
    private final StatsDReporter statsDReporter;
    private final Logger logger;

    public Instrumentation(StatsDReporter statsDReporter, Logger logger) {
        this.statsDReporter = statsDReporter;
        this.logger = logger;
    }

    public Instrumentation(StatsDReporter statsDReporter, Class clazz) {
        this.statsDReporter = statsDReporter;
        this.logger = LoggerFactory.getLogger((Class)clazz);
    }

    public void logInfo(String template, Object ... t) {
        this.logger.info(template, t);
    }

    public void logWarn(String template, Object ... t) {
        this.logger.warn(template, t);
    }

    public void logDebug(String template, Object ... t) {
        this.logger.debug(template, t);
    }

    public void logError(String template, Object ... t) {
        this.logger.error(template, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void captureCount(String metric, Long count, String ... tags) {
        this.statsDReporter.captureCount(metric, count, tags);
    }

    public void captureHistogram(String metric, Long count, String ... tags) {
        this.statsDReporter.captureHistogram(metric, count, tags);
    }

    public void incrementCounter(String metric, String ... tags) {
        this.statsDReporter.increment(metric, tags);
    }

    public void captureValue(String metric, Integer value, String ... tags) {
        this.statsDReporter.gauge(metric, value, tags);
    }

    public void captureDurationSince(String metric, Instant instant, String ... tags) {
        this.statsDReporter.captureDurationSince(metric, instant, tags);
    }

    public void captureDuration(String metric, long duration, String ... tags) {
        this.statsDReporter.captureDuration(metric, duration, tags);
    }

    public void captureNonFatalError(String metric, Throwable e, String template, Object ... t) {
        this.logger.warn(template, t);
        this.logger.warn(e.getMessage(), e);
        this.statsDReporter.recordEvent(metric, "nonfatal", this.errorTag(e, "nonfatal"));
    }

    public void captureFatalError(String metric, Throwable e, String template, Object ... t) {
        this.logger.error(template, t);
        this.logger.error(e.getMessage(), e);
        this.statsDReporter.recordEvent(metric, "fatal", this.errorTag(e, "fatal"));
    }

    private String errorTag(Throwable e, String errorType) {
        return "class=" + e.getClass().getName() + ",type=" + errorType;
    }

    @Override
    public void close() throws IOException {
        this.statsDReporter.close();
    }

    public StatsDReporter getStatsDReporter() {
        return this.statsDReporter;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

