/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis;

import com.gotocompany.depot.Sink;
import com.gotocompany.depot.common.Tuple;
import com.gotocompany.depot.config.RedisSinkConfig;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.redis.RedisSink;
import com.gotocompany.depot.redis.client.RedisClient;
import com.gotocompany.depot.redis.client.RedisClientFactory;
import com.gotocompany.depot.redis.parsers.RedisEntryParser;
import com.gotocompany.depot.redis.parsers.RedisEntryParserFactory;
import com.gotocompany.depot.redis.parsers.RedisParser;
import com.gotocompany.depot.utils.MessageConfigUtils;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;

public class RedisSinkFactory {
    private final RedisSinkConfig sinkConfig;
    private final StatsDReporter statsDReporter;
    private RedisParser redisParser;

    public RedisSinkFactory(RedisSinkConfig sinkConfig, StatsDReporter statsDReporter) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = statsDReporter;
    }

    public RedisSinkFactory(RedisSinkConfig sinkConfig) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]);
    }

    public void init() {
        try {
            Instrumentation instrumentation = new Instrumentation(this.statsDReporter, RedisSinkFactory.class);
            String redisConfig = String.format("\n\tredis.urls = %s\n\tredis.key.template = %s\n\tredis.sink.data.type = %s\n\tredis.deployment.type = %s\n\tredis.ttl.type = %s\n\tredis.ttl.value = %d\n\t", this.sinkConfig.getSinkRedisUrls(), this.sinkConfig.getSinkRedisKeyTemplate(), this.sinkConfig.getSinkRedisDataType().toString(), this.sinkConfig.getSinkRedisDeploymentType().toString(), this.sinkConfig.getSinkRedisTtlType().toString(), this.sinkConfig.getSinkRedisTtlValue());
            switch (this.sinkConfig.getSinkRedisDataType()) {
                case LIST: {
                    redisConfig = redisConfig + "redis.list.data.field.name=" + this.sinkConfig.getSinkRedisListDataFieldName();
                    break;
                }
                case KEYVALUE: {
                    redisConfig = redisConfig + "redis.keyvalue.data.field.name=" + this.sinkConfig.getSinkRedisKeyValueDataFieldName();
                    break;
                }
                case HASHSET: {
                    redisConfig = redisConfig + "redis.hashset.field.to.column.mapping=" + this.sinkConfig.getSinkRedisHashsetFieldToColumnMapping().toString();
                    break;
                }
            }
            instrumentation.logInfo(redisConfig, new Object[0]);
            instrumentation.logInfo("Redis server type = {}", new Object[]{this.sinkConfig.getSinkRedisDeploymentType()});
            MessageParser messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter);
            Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema = MessageConfigUtils.getModeAndSchema(this.sinkConfig);
            RedisEntryParser redisEntryParser = RedisEntryParserFactory.getRedisEntryParser(this.sinkConfig, this.statsDReporter);
            this.redisParser = new RedisParser(messageParser, redisEntryParser, modeAndSchema);
            instrumentation.logInfo("Connection to redis established successfully", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception occurred while creating Redis sink", e);
        }
    }

    public Sink create() {
        RedisClient redisClient = RedisClientFactory.getClient(this.sinkConfig, this.statsDReporter);
        redisClient.init();
        return new RedisSink(redisClient, this.redisParser, new Instrumentation(this.statsDReporter, RedisSink.class));
    }
}

