/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.client;

import com.gotocompany.depot.config.RedisSinkConfig;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.RedisSinkMetrics;
import com.gotocompany.depot.redis.client.RedisClient;
import com.gotocompany.depot.redis.client.response.RedisResponse;
import com.gotocompany.depot.redis.client.response.RedisStandaloneResponse;
import com.gotocompany.depot.redis.record.RedisRecord;
import com.gotocompany.depot.redis.ttl.RedisTTLFactory;
import com.gotocompany.depot.redis.ttl.RedisTtl;
import com.gotocompany.depot.redis.util.RedisSinkUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisStandaloneClient
implements RedisClient {
    private final Instrumentation instrumentation;
    private final RedisTtl redisTTL;
    private final DefaultJedisClientConfig defaultJedisClientConfig;
    private final HostAndPort hostAndPort;
    private Jedis jedis;
    private final int connectionMaxRetries;
    private final long connectionRetryBackoffMs;
    private final RedisSinkMetrics redisSinkMetrics;

    public RedisStandaloneClient(Instrumentation instrumentation, RedisSinkConfig config) {
        this.instrumentation = instrumentation;
        this.connectionMaxRetries = config.getSinkRedisConnectionMaxRetries();
        this.connectionRetryBackoffMs = config.getSinkRedisConnectionRetryBackoffMs();
        this.redisTTL = RedisTTLFactory.getTTl(config);
        this.defaultJedisClientConfig = RedisSinkUtils.getJedisConfig(config);
        this.hostAndPort = RedisStandaloneClient.getHostPort(config);
        this.redisSinkMetrics = new RedisSinkMetrics(config);
    }

    private static HostAndPort getHostPort(RedisSinkConfig config) {
        try {
            return HostAndPort.parseString((String)StringUtils.trim((String)config.getSinkRedisUrls()));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("Invalid url for redis standalone: %s", config.getSinkRedisUrls()));
        }
    }

    @Override
    public List<RedisResponse> send(List<RedisRecord> records) {
        List<RedisResponse> redisResponseList = null;
        for (int retryCount = this.connectionMaxRetries; retryCount >= 0; --retryCount) {
            try {
                redisResponseList = this.sendInternal(records);
                this.instrumentSuccess(redisResponseList);
                break;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                if (retryCount == 0) {
                    this.instrumentFailure(records);
                    throw e;
                }
                this.instrumentation.logInfo("Backing off for " + this.connectionRetryBackoffMs + " milliseconds.", new Object[0]);
                try {
                    Thread.sleep(this.connectionRetryBackoffMs);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.instrumentation.logInfo("Attempting to recreate Redis client. Retry attempt count : " + (this.connectionMaxRetries - retryCount + 1), new Object[0]);
                this.instrumentConnectionRetry();
                this.init();
                continue;
            }
        }
        return redisResponseList;
    }

    public List<RedisResponse> sendInternal(List<RedisRecord> records) {
        Pipeline jedisPipelined = this.jedis.pipelined();
        jedisPipelined.multi();
        List responses = records.stream().map(redisRecord -> redisRecord.send(jedisPipelined, this.redisTTL)).collect(Collectors.toList());
        Response executeResponse = jedisPipelined.exec();
        jedisPipelined.sync();
        this.instrumentation.logDebug("jedis responses: {}", executeResponse.get());
        return responses.stream().map(RedisStandaloneResponse::process).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.instrumentation.logInfo("Closing Jedis client", new Object[0]);
        this.jedis.close();
    }

    @Override
    public void init() {
        this.instrumentation.logInfo("Initialising Jedis client: Host: {} Port: {}", this.hostAndPort.getHost(), this.hostAndPort.getPort());
        this.jedis = new Jedis(this.hostAndPort, (JedisClientConfig)this.defaultJedisClientConfig);
    }

    private void instrumentSuccess(List<RedisResponse> redisResponseList) {
        long successCount = redisResponseList.size();
        this.instrumentation.captureCount(this.redisSinkMetrics.getRedisSuccessResponseTotalMetric(), successCount, new String[0]);
    }

    private void instrumentFailure(List<RedisRecord> validRecords) {
        long failureCount = validRecords.size();
        this.instrumentation.captureCount(this.redisSinkMetrics.getRedisNoResponseTotalMetric(), failureCount, new String[0]);
    }

    private void instrumentConnectionRetry() {
        this.instrumentation.captureCount(this.redisSinkMetrics.getRedisConnectionRetryTotalMetric(), 1L, new String[0]);
    }

    public RedisStandaloneClient(Instrumentation instrumentation, RedisTtl redisTTL, DefaultJedisClientConfig defaultJedisClientConfig, HostAndPort hostAndPort, Jedis jedis, int connectionMaxRetries, long connectionRetryBackoffMs, RedisSinkMetrics redisSinkMetrics) {
        this.instrumentation = instrumentation;
        this.redisTTL = redisTTL;
        this.defaultJedisClientConfig = defaultJedisClientConfig;
        this.hostAndPort = hostAndPort;
        this.jedis = jedis;
        this.connectionMaxRetries = connectionMaxRetries;
        this.connectionRetryBackoffMs = connectionRetryBackoffMs;
        this.redisSinkMetrics = redisSinkMetrics;
    }
}

