/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.client.entry;

import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.response.RedisClusterResponse;
import com.gotocompany.depot.redis.client.response.RedisStandaloneResponse;
import com.gotocompany.depot.redis.ttl.RedisTtl;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisException;

public class RedisKeyValueEntry
implements RedisEntry {
    private final String key;
    private final String value;
    private final Instrumentation instrumentation;

    @Override
    public RedisStandaloneResponse send(Pipeline jedisPipelined, RedisTtl redisTTL) {
        this.instrumentation.logDebug("key: {}, value: {}", this.key, this.value);
        Response response = jedisPipelined.set(this.key, this.value);
        Response<Long> ttlResponse = redisTTL.setTtl(jedisPipelined, this.key);
        return new RedisStandaloneResponse("SET", response, ttlResponse);
    }

    @Override
    public RedisClusterResponse send(JedisCluster jedisCluster, RedisTtl redisTTL) {
        this.instrumentation.logDebug("key: {}, value: {}", this.key, this.value);
        try {
            String response = jedisCluster.set(this.key, this.value);
            Long ttlResponse = redisTTL.setTtl(jedisCluster, this.key);
            return new RedisClusterResponse("SET", response, ttlResponse);
        }
        catch (JedisException e) {
            return new RedisClusterResponse(e.getMessage());
        }
    }

    public String toString() {
        return String.format("RedisKeyValueEntry: Key %s, Value %s", this.key, this.value);
    }

    public RedisKeyValueEntry(String key, String value, Instrumentation instrumentation) {
        this.key = key;
        this.value = value;
        this.instrumentation = instrumentation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisKeyValueEntry)) {
            return false;
        }
        RedisKeyValueEntry other = (RedisKeyValueEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisKeyValueEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

