/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.parsers;

import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.entry.RedisHashSetFieldEntry;
import com.gotocompany.depot.redis.parsers.RedisEntryParser;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RedisHashSetEntryParser
implements RedisEntryParser {
    private final StatsDReporter statsDReporter;
    private final Template keyTemplate;
    private final Map<String, Template> fieldTemplates;

    @Override
    public List<RedisEntry> getRedisEntry(ParsedMessage parsedMessage) {
        String redisKey = this.keyTemplate.parse(parsedMessage);
        return this.fieldTemplates.entrySet().stream().map(fieldTemplate -> {
            String field = ((Template)fieldTemplate.getValue()).parse(parsedMessage);
            String redisValue = parsedMessage.getFieldByName((String)fieldTemplate.getKey()).toString();
            return new RedisHashSetFieldEntry(redisKey, field, redisValue, new Instrumentation(this.statsDReporter, RedisHashSetFieldEntry.class));
        }).collect(Collectors.toList());
    }

    public RedisHashSetEntryParser(StatsDReporter statsDReporter, Template keyTemplate, Map<String, Template> fieldTemplates) {
        this.statsDReporter = statsDReporter;
        this.keyTemplate = keyTemplate;
        this.fieldTemplates = fieldTemplates;
    }
}

