/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.parsers;

import com.gotocompany.depot.common.Tuple;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.parsers.RedisEntryParser;
import com.gotocompany.depot.redis.record.RedisRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisParser {
    private static final Logger log = LoggerFactory.getLogger(RedisParser.class);
    private final MessageParser messageParser;
    private final RedisEntryParser redisEntryParser;
    private final Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema;

    public List<RedisRecord> convert(List<Message> messages) {
        ArrayList<RedisRecord> records = new ArrayList<RedisRecord>();
        IntStream.range(0, messages.size()).forEach(index -> {
            try {
                ParsedMessage parsedMessage = this.messageParser.parse((Message)messages.get(index), this.modeAndSchema.getFirst(), this.modeAndSchema.getSecond());
                List<RedisEntry> redisDataEntries = this.redisEntryParser.getRedisEntry(parsedMessage);
                for (RedisEntry redisEntry : redisDataEntries) {
                    records.add(new RedisRecord(redisEntry, Long.valueOf(index), null, ((Message)messages.get(index)).getMetadataString(), true));
                }
            }
            catch (UnsupportedOperationException e) {
                records.add(this.createAndLogErrorRecord(e, ErrorType.INVALID_MESSAGE_ERROR, index, messages));
            }
            catch (ConfigurationException e) {
                records.add(this.createAndLogErrorRecord(e, ErrorType.UNKNOWN_FIELDS_ERROR, index, messages));
            }
            catch (IllegalArgumentException e) {
                records.add(this.createAndLogErrorRecord(e, ErrorType.DEFAULT_ERROR, index, messages));
            }
            catch (DeserializerException | IOException e) {
                records.add(this.createAndLogErrorRecord(e, ErrorType.DESERIALIZATION_ERROR, index, messages));
            }
        });
        return records;
    }

    private RedisRecord createAndLogErrorRecord(Exception e, ErrorType type, int index, List<Message> messages) {
        ErrorInfo errorInfo = new ErrorInfo(e, type);
        RedisRecord record = new RedisRecord(null, Long.valueOf(index), errorInfo, messages.get(index).getMetadataString(), false);
        log.error("Error while parsing record for message. Record: {}, Error: {}", (Object)record, (Object)errorInfo);
        return record;
    }

    public RedisParser(MessageParser messageParser, RedisEntryParser redisEntryParser, Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema) {
        this.messageParser = messageParser;
        this.redisEntryParser = redisEntryParser;
        this.modeAndSchema = modeAndSchema;
    }
}

