/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.schema.json;

import com.gotocompany.depot.schema.Schema;
import com.gotocompany.depot.schema.SchemaField;
import com.gotocompany.depot.schema.SchemaFieldType;
import com.gotocompany.depot.schema.json.GenericJsonSchema;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenericJsonSchemaField
implements SchemaField {
    private final String name;
    private final SchemaFieldType type;
    private final boolean isRepeated;
    private final Object value;

    public GenericJsonSchemaField(String fieldName, Object value) {
        this.name = fieldName;
        this.type = this.getFieldType(value);
        this.value = value;
        this.isRepeated = value instanceof JSONArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJsonName() {
        return this.name;
    }

    private SchemaFieldType getFieldType(Object inputValue) {
        if (inputValue instanceof JSONObject) {
            return SchemaFieldType.MESSAGE;
        }
        if (inputValue instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)inputValue;
            return jsonArray.isEmpty() ? SchemaFieldType.STRING : this.getFieldType(jsonArray.get(0));
        }
        if (inputValue instanceof BigDecimal) {
            return SchemaFieldType.DOUBLE;
        }
        if (inputValue instanceof Integer) {
            return SchemaFieldType.INT;
        }
        if (inputValue instanceof Float) {
            return SchemaFieldType.FLOAT;
        }
        if (inputValue instanceof Long) {
            return SchemaFieldType.LONG;
        }
        if (inputValue == Boolean.TRUE || inputValue == Boolean.FALSE) {
            return SchemaFieldType.BOOLEAN;
        }
        return SchemaFieldType.STRING;
    }

    @Override
    public SchemaFieldType getType() {
        return this.type;
    }

    @Override
    public Schema getValueType() {
        return new GenericJsonSchema((JSONObject)this.value);
    }

    @Override
    public boolean isRepeated() {
        return this.isRepeated;
    }
}

