/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.converter;

import com.google.api.client.util.DateTime;
import com.google.api.client.util.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverterUtils;
import com.gotocompany.depot.bigquery.models.Record;
import com.gotocompany.depot.bigquery.models.Records;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.exception.UnknownFieldsException;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.ProtoUnknownFieldValidationType;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.schema.LogicalType;
import com.gotocompany.depot.schema.SchemaField;
import com.gotocompany.depot.schema.SchemaFieldType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRecordConverter {
    private static final Logger log = LoggerFactory.getLogger(MessageRecordConverter.class);
    private final MessageParser parser;
    private final BigQuerySinkConfig config;
    private final ProtoUnknownFieldValidationType unknownFieldValidationType;
    private final boolean sinkConnectorSchemaProtoAllowUnknownFieldsEnable;

    public MessageRecordConverter(MessageParser parser, BigQuerySinkConfig config) {
        this.parser = parser;
        this.config = config;
        this.unknownFieldValidationType = config.getSinkConnectorSchemaProtoUnknownFieldsValidation();
        this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable = config.getSinkConnectorSchemaProtoAllowUnknownFieldsEnable();
    }

    public Records convert(List<Message> messages) {
        ArrayList<Record> validRecords = new ArrayList<Record>();
        ArrayList<Record> invalidRecords = new ArrayList<Record>();
        for (int index = 0; index < messages.size(); ++index) {
            ErrorInfo errorInfo;
            Message message = messages.get(index);
            try {
                Record record = this.createRecord(message, index);
                validRecords.add(record);
                continue;
            }
            catch (UnknownFieldsException e) {
                errorInfo = new ErrorInfo(e, ErrorType.UNKNOWN_FIELDS_ERROR);
                invalidRecords.add(new Record(message.getMetadata(), Collections.emptyMap(), index, errorInfo));
                continue;
            }
            catch (EmptyMessageException | UnsupportedOperationException e) {
                errorInfo = new ErrorInfo(e, ErrorType.INVALID_MESSAGE_ERROR);
                invalidRecords.add(new Record(message.getMetadata(), Collections.emptyMap(), index, errorInfo));
                continue;
            }
            catch (DeserializerException | IllegalArgumentException e) {
                errorInfo = new ErrorInfo(e, ErrorType.DESERIALIZATION_ERROR);
                invalidRecords.add(new Record(message.getMetadata(), Collections.emptyMap(), index, errorInfo));
            }
        }
        return new Records(validRecords, invalidRecords);
    }

    private Record createRecord(Message message, int index) {
        try {
            SinkConnectorSchemaMessageMode mode = this.config.getSinkConnectorSchemaMessageMode();
            String schemaClass = mode == SinkConnectorSchemaMessageMode.LOG_MESSAGE ? this.config.getSinkConnectorSchemaProtoMessageClass() : this.config.getSinkConnectorSchemaProtoKeyClass();
            ParsedMessage parsedMessage = this.parser.parse(message, mode, schemaClass);
            if (!this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable) {
                parsedMessage.validate(this.unknownFieldValidationType);
            }
            Map<String, Object> columns = this.getMapping(parsedMessage);
            MessageRecordConverterUtils.addMetadata(columns, message, this.config);
            MessageRecordConverterUtils.addTimeStampColumnForJson(columns, this.config);
            return new Record(message.getMetadata(), columns, index, null);
        }
        catch (IOException e) {
            log.error("failed to deserialize message: {}, {} ", (Object)e, (Object)message.getMetadataString());
            throw new DeserializerException("failed to deserialize ", e);
        }
    }

    private void floatCheck(Object fieldValue) {
        if (fieldValue instanceof Float) {
            float floatValue = ((Number)fieldValue).floatValue();
            Preconditions.checkArgument((!Float.isInfinite(floatValue) && !Float.isNaN(floatValue) ? 1 : 0) != 0);
        } else if (fieldValue instanceof Double) {
            double doubleValue = ((Number)fieldValue).doubleValue();
            Preconditions.checkArgument((!Double.isInfinite(doubleValue) && !Double.isNaN(doubleValue) ? 1 : 0) != 0);
        }
    }

    private Object getFieldValue(SchemaField field, Object value) {
        if (field.getType().equals((Object)SchemaFieldType.FLOAT) || field.getType().equals((Object)SchemaFieldType.DOUBLE)) {
            this.floatCheck(value);
        }
        if (field.getType().equals((Object)SchemaFieldType.BYTES)) {
            return BaseEncoding.base64().encode(((ByteString)value).toByteArray());
        }
        if (field.getType().equals((Object)SchemaFieldType.MESSAGE)) {
            ParsedMessage msg = (ParsedMessage)value;
            if (msg.getSchema().logicalType().equals((Object)LogicalType.TIMESTAMP)) {
                return new DateTime(msg.getLogicalValue().getTimestamp().toEpochMilli());
            }
            if (msg.getSchema().logicalType().equals((Object)LogicalType.STRUCT)) {
                JSONObject json = new JSONObject(msg.getLogicalValue().getStruct());
                return json.toString();
            }
            return this.getMapping(msg);
        }
        return value;
    }

    private Object getListValue(SchemaField schemaField, List<?> value) {
        return value.stream().map(eachValue -> this.getFieldValue(schemaField, eachValue)).collect(Collectors.toList());
    }

    private Object getValue(Map.Entry<SchemaField, Object> kv) {
        SchemaField schemaField = kv.getKey();
        Object value = kv.getValue();
        if (schemaField.isRepeated()) {
            return this.getListValue(schemaField, (List)value);
        }
        return this.getFieldValue(schemaField, value);
    }

    private Map<String, Object> getMapping(ParsedMessage msg) {
        return msg.getFields().entrySet().stream().collect(Collectors.toMap(kv -> ((SchemaField)kv.getKey()).getName(), this::getValue));
    }
}

