/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.models;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.protobuf.DescriptorProtos;
import com.gotocompany.depot.bigquery.exception.BQSchemaMappingException;
import com.gotocompany.depot.message.proto.ProtoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BQField {
    private static final Map<DescriptorProtos.FieldDescriptorProto.Label, Field.Mode> FIELD_LABEL_TO_BQ_MODE_MAP = new HashMap<DescriptorProtos.FieldDescriptorProto.Label, Field.Mode>(){
        {
            this.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, Field.Mode.NULLABLE);
            this.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, Field.Mode.REPEATED);
            this.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED, Field.Mode.REQUIRED);
        }
    };
    private static final Map<DescriptorProtos.FieldDescriptorProto.Type, LegacySQLTypeName> FIELD_TYPE_TO_BQ_TYPE_MAP = new HashMap<DescriptorProtos.FieldDescriptorProto.Type, LegacySQLTypeName>(){
        {
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, LegacySQLTypeName.BYTES);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, LegacySQLTypeName.STRING);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, LegacySQLTypeName.STRING);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, LegacySQLTypeName.FLOAT);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, LegacySQLTypeName.FLOAT);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, LegacySQLTypeName.BOOLEAN);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, LegacySQLTypeName.INTEGER);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, LegacySQLTypeName.RECORD);
            this.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_GROUP, LegacySQLTypeName.RECORD);
        }
    };
    private static final Map<String, LegacySQLTypeName> FIELD_NAME_TO_BQ_TYPE_MAP = new HashMap<String, LegacySQLTypeName>(){
        {
            this.put(".google.protobuf.Timestamp", LegacySQLTypeName.TIMESTAMP);
            this.put(".google.protobuf.Struct", LegacySQLTypeName.STRING);
            this.put(".google.protobuf.Duration", LegacySQLTypeName.RECORD);
        }
    };
    private final String name;
    private final Field.Mode mode;
    private final LegacySQLTypeName type;
    private List<Field> subFields;

    public BQField(String name, Field.Mode mode, LegacySQLTypeName type, List<Field> subFields) {
        this.name = name;
        this.mode = mode;
        this.type = type;
        this.subFields = subFields;
    }

    public BQField(ProtoField protoField) {
        this.name = protoField.getName();
        this.mode = FIELD_LABEL_TO_BQ_MODE_MAP.get(protoField.getLabel());
        this.type = this.getType(protoField);
        this.subFields = new ArrayList<Field>();
    }

    private LegacySQLTypeName getType(ProtoField protoField) {
        LegacySQLTypeName typeFromFieldName;
        LegacySQLTypeName legacySQLTypeName = typeFromFieldName = FIELD_NAME_TO_BQ_TYPE_MAP.get(protoField.getTypeName()) != null ? FIELD_NAME_TO_BQ_TYPE_MAP.get(protoField.getTypeName()) : FIELD_TYPE_TO_BQ_TYPE_MAP.get(protoField.getType());
        if (typeFromFieldName == null) {
            throw new BQSchemaMappingException(String.format("No type mapping found for field: %s, fieldType: %s, typeName: %s", protoField.getName(), protoField.getType(), protoField.getTypeName()));
        }
        return typeFromFieldName;
    }

    public void setSubFields(List<Field> fields) {
        this.subFields = fields;
    }

    public Field getField() {
        if (this.subFields == null || this.subFields.size() == 0) {
            return Field.newBuilder((String)this.name, (LegacySQLTypeName)this.type, (Field[])new Field[0]).setMode(this.mode).build();
        }
        return Field.newBuilder((String)this.name, (LegacySQLTypeName)this.type, (FieldList)FieldList.of(this.subFields)).setMode(this.mode).build();
    }

    public String getName() {
        return this.name;
    }

    public LegacySQLTypeName getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BQField)) {
            return false;
        }
        BQField other = (BQField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Field.Mode this$mode = this.mode;
        Field.Mode other$mode = other.mode;
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        LegacySQLTypeName this$type = this.getType();
        LegacySQLTypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Field> this$subFields = this.subFields;
        List<Field> other$subFields = other.subFields;
        return !(this$subFields == null ? other$subFields != null : !((Object)this$subFields).equals(other$subFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BQField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Field.Mode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        LegacySQLTypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Field> $subFields = this.subFields;
        result = result * 59 + ($subFields == null ? 43 : ((Object)$subFields).hashCode());
        return result;
    }
}

