/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigtable.client;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.gotocompany.depot.bigtable.exception.BigTableInvalidSchemaException;
import com.gotocompany.depot.bigtable.model.BigTableRecord;
import com.gotocompany.depot.bigtable.model.BigTableSchema;
import com.gotocompany.depot.bigtable.response.BigTableResponse;
import com.gotocompany.depot.config.BigTableSinkConfig;
import com.gotocompany.depot.metrics.BigTableMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BigTableClient {
    private final BigtableTableAdminClient bigtableTableAdminClient;
    private final BigtableDataClient bigtableDataClient;
    private final BigTableSinkConfig sinkConfig;
    private final BigTableSchema bigtableSchema;
    private final BigTableMetrics bigtableMetrics;
    private final Instrumentation instrumentation;

    public BigTableClient(BigTableSinkConfig sinkConfig, BigTableSchema bigtableSchema, BigTableMetrics bigtableMetrics, Instrumentation instrumentation) throws IOException {
        this(sinkConfig, BigTableClient.getBigTableDataClient(sinkConfig), BigTableClient.getBigTableAdminClient(sinkConfig), bigtableSchema, bigtableMetrics, instrumentation);
    }

    public BigTableClient(BigTableSinkConfig sinkConfig, BigtableDataClient bigtableDataClient, BigtableTableAdminClient bigtableTableAdminClient, BigTableSchema bigtableSchema, BigTableMetrics bigtableMetrics, Instrumentation instrumentation) {
        this.sinkConfig = sinkConfig;
        this.bigtableDataClient = bigtableDataClient;
        this.bigtableTableAdminClient = bigtableTableAdminClient;
        this.bigtableSchema = bigtableSchema;
        this.bigtableMetrics = bigtableMetrics;
        this.instrumentation = instrumentation;
    }

    private static BigtableDataClient getBigTableDataClient(BigTableSinkConfig sinkConfig) throws IOException {
        BigtableDataSettings settings = BigtableDataSettings.newBuilder().setProjectId(sinkConfig.getGCloudProjectID()).setInstanceId(sinkConfig.getInstanceId()).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(sinkConfig.getCredentialPath())))).build();
        return BigtableDataClient.create((BigtableDataSettings)settings);
    }

    private static BigtableTableAdminClient getBigTableAdminClient(BigTableSinkConfig sinkConfig) throws IOException {
        BigtableTableAdminSettings settings = BigtableTableAdminSettings.newBuilder().setProjectId(sinkConfig.getGCloudProjectID()).setInstanceId(sinkConfig.getInstanceId()).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(sinkConfig.getCredentialPath())))).build();
        return BigtableTableAdminClient.create((BigtableTableAdminSettings)settings);
    }

    public BigTableResponse send(List<BigTableRecord> records) {
        BigTableResponse bigTableResponse = null;
        BulkMutation batch = BulkMutation.create((String)this.sinkConfig.getTableId());
        records.forEach(record -> batch.add(record.getRowMutationEntry()));
        try {
            Instant startTime = Instant.now();
            this.bigtableDataClient.bulkMutateRows(batch);
            this.instrument(startTime, batch.getEntryCount());
        }
        catch (MutateRowsException e) {
            bigTableResponse = new BigTableResponse(e);
            this.instrumentation.logError("Some entries failed to be applied. {}", e.getCause());
        }
        return bigTableResponse;
    }

    private void instrument(Instant startTime, long entryCount) {
        this.instrumentation.captureDurationSince(this.bigtableMetrics.getBigtableOperationLatencyMetric(), startTime, String.format("instance=%s", this.sinkConfig.getInstanceId()), String.format("table=%s", this.sinkConfig.getTableId()));
        this.instrumentation.captureCount(this.bigtableMetrics.getBigtableOperationTotalMetric(), entryCount, String.format("instance=%s", this.sinkConfig.getInstanceId()), String.format("table=%s", this.sinkConfig.getTableId()));
    }

    public void validateBigTableSchema() throws BigTableInvalidSchemaException {
        String tableId = this.sinkConfig.getTableId();
        this.instrumentation.logDebug(String.format("Validating schema for table: %s...", tableId), new Object[0]);
        this.checkIfTableExists(tableId);
        this.checkIfColumnFamiliesExist(tableId);
        this.instrumentation.logDebug("Validation complete, Schema is valid.", new Object[0]);
    }

    private void checkIfTableExists(String tableId) throws BigTableInvalidSchemaException {
        if (!this.bigtableTableAdminClient.exists(tableId)) {
            throw new BigTableInvalidSchemaException(String.format("Table not found on the path: projects/%s/instances/%s/tables/%s", this.bigtableTableAdminClient.getProjectId(), this.bigtableTableAdminClient.getInstanceId(), tableId));
        }
    }

    private void checkIfColumnFamiliesExist(String tableId) throws BigTableInvalidSchemaException {
        Set<String> existingColumnFamilies = this.bigtableTableAdminClient.getTable(tableId).getColumnFamilies().stream().map(ColumnFamily::getId).collect(Collectors.toSet());
        Set<String> missingColumnFamilies = this.bigtableSchema.getMissingColumnFamilies(existingColumnFamilies);
        if (missingColumnFamilies.size() > 0) {
            throw new BigTableInvalidSchemaException(String.format("Column families %s do not exist in table %s!", missingColumnFamilies, tableId));
        }
    }
}

