/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigtable.model;

import com.gotocompany.depot.exception.ConfigurationException;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class BigTableSchema {
    private final JSONObject columnFamilyMapping;

    public BigTableSchema(String columnMapping) {
        if (columnMapping == null || columnMapping.isEmpty()) {
            throw new ConfigurationException("Column Mapping should not be empty or null");
        }
        this.columnFamilyMapping = new JSONObject(columnMapping);
    }

    public String getField(String columnFamily, String columnName) {
        JSONObject columns = this.columnFamilyMapping.getJSONObject(columnFamily);
        return columns.getString(columnName);
    }

    public Set<String> getColumnFamilies() {
        return this.columnFamilyMapping.keySet();
    }

    public Set<String> getColumns(String family) {
        return this.columnFamilyMapping.getJSONObject(family).keySet();
    }

    public Set<String> getMissingColumnFamilies(Set<String> existingColumnFamilies) {
        HashSet<String> tempSet = new HashSet<String>(this.getColumnFamilies());
        tempSet.removeAll(existingColumnFamilies);
        return tempSet;
    }
}

