/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.common.client.auth;

import org.joda.time.DateTimeUtils;

public class OAuth2AccessToken {
    private final String accessToken;
    private final Long expirationTimeMs;
    private static final int DEFAULT_EXPIRATION_TIME = 3600;
    private static final long MILLIS = 1000L;

    public OAuth2AccessToken(String accessToken, Integer expiresIn) {
        this.accessToken = accessToken;
        expiresIn = expiresIn == null ? 3600 : expiresIn;
        this.expirationTimeMs = DateTimeUtils.currentTimeMillis() + (long)expiresIn.intValue() * 1000L;
    }

    public boolean isExpired() {
        long oneMinute = 60L;
        return this.getExpiresIn() <= 60L;
    }

    public String toString() {
        return this.accessToken;
    }

    public Long getExpiresIn() {
        return (this.expirationTimeMs - DateTimeUtils.currentTimeMillis()) / 1000L;
    }
}

