/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config;

import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.config.HttpClientConfig;
import com.gotocompany.depot.config.converter.HttpHeaderConverter;
import com.gotocompany.depot.config.converter.HttpParameterSourceTypeConverter;
import com.gotocompany.depot.config.converter.HttpRequestBodyTypeConverter;
import com.gotocompany.depot.config.converter.HttpRequestMethodConverter;
import com.gotocompany.depot.config.converter.HttpRequestTypeConverter;
import com.gotocompany.depot.config.converter.RangeToHashMapConverter;
import com.gotocompany.depot.config.converter.TemplateMapConverter;
import com.gotocompany.depot.http.enums.HttpParameterSourceType;
import com.gotocompany.depot.http.enums.HttpRequestBodyType;
import com.gotocompany.depot.http.enums.HttpRequestMethodType;
import com.gotocompany.depot.http.enums.HttpRequestType;
import java.util.Map;
import org.aeonbits.owner.Config;

@Config.DisableFeature(value={Config.DisableableFeature.PARAMETER_FORMATTING})
public interface HttpSinkConfig
extends HttpClientConfig {
    @Config.Key(value="SINK_HTTPV2_SERVICE_URL")
    public String getSinkHttpServiceUrl();

    @Config.Key(value="SINK_HTTPV2_REQUEST_METHOD")
    @Config.DefaultValue(value="put")
    @Config.ConverterClass(value=HttpRequestMethodConverter.class)
    public HttpRequestMethodType getSinkHttpRequestMethod();

    @Config.Key(value="SINK_HTTPV2_HEADERS")
    @Config.DefaultValue(value="")
    @Config.ConverterClass(value=HttpHeaderConverter.class)
    public Map<String, String> getSinkHttpHeaders();

    @Config.Key(value="SINK_HTTPV2_HEADERS_TEMPLATE")
    @Config.DefaultValue(value="")
    @Config.ConverterClass(value=TemplateMapConverter.class)
    public Map<Template, Template> getSinkHttpHeadersTemplate();

    @Config.Key(value="SINK_HTTPV2_HEADERS_PARAMETER_SOURCE")
    @Config.DefaultValue(value="MESSAGE")
    @Config.ConverterClass(value=HttpParameterSourceTypeConverter.class)
    public HttpParameterSourceType getSinkHttpHeadersParameterSource();

    @Config.Key(value="SINK_HTTPV2_QUERY_TEMPLATE")
    @Config.DefaultValue(value="")
    @Config.ConverterClass(value=TemplateMapConverter.class)
    public Map<Template, Template> getQueryTemplate();

    @Config.Key(value="SINK_HTTPV2_QUERY_PARAMETER_SOURCE")
    @Config.DefaultValue(value="MESSAGE")
    @Config.ConverterClass(value=HttpParameterSourceTypeConverter.class)
    public HttpParameterSourceType getQueryParamSourceMode();

    @Config.Key(value="SINK_HTTPV2_REQUEST_MODE")
    @Config.DefaultValue(value="SINGLE")
    @Config.ConverterClass(value=HttpRequestTypeConverter.class)
    public HttpRequestType getRequestType();

    @Config.Key(value="SINK_HTTPV2_REQUEST_BODY_MODE")
    @Config.DefaultValue(value="RAW")
    @Config.ConverterClass(value=HttpRequestBodyTypeConverter.class)
    public HttpRequestBodyType getRequestBodyType();

    @Config.Key(value="SINK_HTTPV2_REQUEST_LOG_STATUS_CODE_RANGES")
    @Config.DefaultValue(value="400-600")
    @Config.ConverterClass(value=RangeToHashMapConverter.class)
    public Map<Integer, Boolean> getSinkHttpRequestLogStatusCodeRanges();

    @Config.Key(value="SINK_HTTPV2_RETRY_STATUS_CODE_RANGES")
    @Config.DefaultValue(value="400-600")
    @Config.ConverterClass(value=RangeToHashMapConverter.class)
    public Map<Integer, Boolean> getSinkHttpRetryStatusCodeRanges();

    @Config.Key(value="SINK_HTTPV2_JSON_BODY_TEMPLATE")
    @Config.DefaultValue(value="")
    public String getSinkHttpJsonBodyTemplate();

    @Override
    @Config.Key(value="SINK_HTTPV2_DEFAULT_FIELD_VALUE_ENABLE")
    @Config.DefaultValue(value="true")
    public boolean getSinkDefaultFieldValueEnable();

    @Config.Key(value="SINK_HTTPV2_DELETE_BODY_ENABLE")
    @Config.DefaultValue(value="true")
    public Boolean isSinkHttpDeleteBodyEnable();
}

