/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http;

import com.gotocompany.depot.Sink;
import com.gotocompany.depot.common.client.HttpClientUtils;
import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.InvalidTemplateException;
import com.gotocompany.depot.http.HttpSink;
import com.gotocompany.depot.http.client.HttpSinkClient;
import com.gotocompany.depot.http.request.Request;
import com.gotocompany.depot.http.request.RequestFactory;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.metrics.HttpSinkMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpSinkFactory {
    private final HttpSinkConfig sinkConfig;
    private final StatsDReporter statsDReporter;
    private HttpSinkClient httpSinkClient;
    private Request request;

    public HttpSinkFactory(HttpSinkConfig sinkConfig, StatsDReporter statsDReporter) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = statsDReporter;
    }

    public HttpSinkFactory(HttpSinkConfig sinkConfig) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]);
    }

    public void init() {
        try {
            CloseableHttpClient closeableHttpClient = HttpClientUtils.newHttpClient(this.sinkConfig, this.statsDReporter);
            HttpSinkMetrics httpSinkMetrics = new HttpSinkMetrics(this.sinkConfig);
            this.httpSinkClient = new HttpSinkClient((HttpClient)closeableHttpClient, httpSinkMetrics, new Instrumentation(this.statsDReporter, HttpSinkClient.class));
            MessageParser messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter);
            this.request = RequestFactory.create(this.sinkConfig, messageParser);
        }
        catch (ConfigurationException | InvalidTemplateException e) {
            throw new IllegalArgumentException("Exception occurred while creating Http sink", e);
        }
    }

    public Sink create() {
        return new HttpSink(this.httpSinkClient, this.request, this.sinkConfig.getSinkHttpRetryStatusCodeRanges(), this.sinkConfig.getSinkHttpRequestLogStatusCodeRanges(), new Instrumentation(this.statsDReporter, HttpSink.class));
    }
}

