/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.response;

import com.gotocompany.depot.metrics.Instrumentation;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpSinkResponse {
    protected static final String SUCCESS_CODE_PATTERN = "^2.*";
    private boolean isFail;
    private int responseCode;
    private String responseBody;
    private boolean shouldLogResponse;

    public HttpSinkResponse(HttpResponse response, Instrumentation instrumentation) throws IOException {
        this.setIsFail(response);
        this.setResponseCode(response);
        this.setShouldLogResponse(instrumentation);
        this.setResponseBody(response);
    }

    private void setIsFail(HttpResponse response) {
        this.isFail = true;
        if (HttpSinkResponse.hasStatusLine(response)) {
            this.isFail = !Pattern.compile(SUCCESS_CODE_PATTERN).matcher(String.valueOf(response.getStatusLine().getStatusCode())).matches();
        }
    }

    private void setResponseCode(HttpResponse response) {
        this.responseCode = HttpSinkResponse.hasStatusLine(response) ? response.getStatusLine().getStatusCode() : -1;
    }

    private static boolean hasStatusLine(HttpResponse response) {
        return response != null && response.getStatusLine() != null;
    }

    private void setResponseBody(HttpResponse response) throws IOException {
        if (!this.hasResponse(response)) {
            return;
        }
        if (this.shouldLogResponse || this.isFail) {
            this.responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        } else {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public boolean isFail() {
        return this.isFail;
    }

    public boolean shouldLogResponse() {
        return this.shouldLogResponse;
    }

    public void setShouldLogResponse(Instrumentation instrumentation) {
        this.shouldLogResponse = instrumentation.isDebugEnabled();
    }

    private boolean hasResponse(HttpResponse response) {
        return Objects.nonNull(response) && Objects.nonNull(response.getEntity());
    }
}

