/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.log;

import com.gotocompany.depot.Sink;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.log.LogSink;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;

public class LogSinkFactory {
    private final StatsDReporter statsDReporter;
    private MessageParser messageParser;
    private final SinkConfig sinkConfig;

    public LogSinkFactory(Map<String, String> env, StatsDReporter statsDReporter) {
        this((SinkConfig)ConfigFactory.create(SinkConfig.class, (Map[])new Map[]{env}), statsDReporter);
    }

    public LogSinkFactory(SinkConfig sinkConfig, StatsDReporter statsDReporter) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = statsDReporter;
    }

    public LogSinkFactory(SinkConfig sinkConfig) {
        this(sinkConfig, new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]));
    }

    public void init() {
        this.messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter);
    }

    public Sink create() {
        return new LogSink(this.sinkConfig, this.messageParser, new Instrumentation(this.statsDReporter, LogSink.class));
    }
}

