/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute;

import com.google.protobuf.Descriptors;
import com.gotocompany.depot.Sink;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.maxcompute.MaxComputeSink;
import com.gotocompany.depot.maxcompute.client.MaxComputeClient;
import com.gotocompany.depot.maxcompute.converter.ProtobufConverterOrchestrator;
import com.gotocompany.depot.maxcompute.converter.record.ProtoMessageRecordConverter;
import com.gotocompany.depot.maxcompute.record.RecordDecorator;
import com.gotocompany.depot.maxcompute.record.RecordDecoratorFactory;
import com.gotocompany.depot.maxcompute.schema.MaxComputeSchemaCache;
import com.gotocompany.depot.maxcompute.schema.MaxComputeSchemaCacheFactory;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategy;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategyFactory;
import com.gotocompany.depot.maxcompute.util.MetadataUtil;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.stencil.client.StencilClient;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;

public class MaxComputeSinkFactory {
    private final MaxComputeSinkConfig maxComputeSinkConfig;
    private final SinkConfig sinkConfig;
    private final StatsDReporter statsDReporter;
    private final StencilClient stencilClient;
    private final ProtobufConverterOrchestrator protobufConverterOrchestrator;
    private final MaxComputeMetrics maxComputeMetrics;
    private final MaxComputeClient maxComputeClient;
    private final MetadataUtil metadataUtil;
    private MaxComputeSchemaCache maxComputeSchemaCache;
    private PartitioningStrategy partitioningStrategy;
    private MessageParser messageParser;

    public MaxComputeSinkFactory(StatsDReporter statsDReporter, StencilClient stencilClient, Map<String, String> env) {
        this.statsDReporter = statsDReporter;
        this.maxComputeSinkConfig = (MaxComputeSinkConfig)ConfigFactory.create(MaxComputeSinkConfig.class, (Map[])new Map[]{env});
        this.sinkConfig = (SinkConfig)ConfigFactory.create(SinkConfig.class, (Map[])new Map[]{env});
        this.stencilClient = stencilClient;
        this.protobufConverterOrchestrator = new ProtobufConverterOrchestrator(this.maxComputeSinkConfig);
        this.maxComputeMetrics = new MaxComputeMetrics(this.sinkConfig);
        this.maxComputeClient = new MaxComputeClient(this.maxComputeSinkConfig, statsDReporter, this.maxComputeMetrics);
        this.metadataUtil = new MetadataUtil(this.maxComputeSinkConfig);
    }

    public void init() {
        Descriptors.Descriptor descriptor = this.stencilClient.get(MaxComputeSinkFactory.getProtoSchemaClassName(this.sinkConfig));
        this.partitioningStrategy = PartitioningStrategyFactory.createPartitioningStrategy(this.protobufConverterOrchestrator, this.maxComputeSinkConfig, descriptor);
        this.maxComputeSchemaCache = MaxComputeSchemaCacheFactory.createMaxComputeSchemaCache(this.protobufConverterOrchestrator, this.maxComputeSinkConfig, this.partitioningStrategy, this.sinkConfig, this.maxComputeClient, this.metadataUtil);
        this.messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter, this.maxComputeSchemaCache);
        this.maxComputeSchemaCache.setMessageParser(this.messageParser);
        this.maxComputeSchemaCache.updateSchema();
    }

    public Sink create() {
        RecordDecorator recordDecorator = RecordDecoratorFactory.createRecordDecorator(new RecordDecoratorFactory.RecordDecoratorConfig(this.protobufConverterOrchestrator, this.maxComputeSchemaCache, this.messageParser, this.partitioningStrategy, this.maxComputeSinkConfig, this.sinkConfig, this.statsDReporter, this.maxComputeMetrics, this.metadataUtil));
        ProtoMessageRecordConverter protoMessageRecordConverter = new ProtoMessageRecordConverter(recordDecorator, this.maxComputeSchemaCache);
        return new MaxComputeSink(this.maxComputeClient.createInsertManager(), protoMessageRecordConverter, this.statsDReporter, this.maxComputeMetrics);
    }

    private static String getProtoSchemaClassName(SinkConfig sinkConfig) {
        return SinkConnectorSchemaMessageMode.LOG_MESSAGE == sinkConfig.getSinkConnectorSchemaMessageMode() ? sinkConfig.getSinkConnectorSchemaProtoMessageClass() : sinkConfig.getSinkConnectorSchemaProtoKeyClass();
    }
}

