/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.client;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.tunnel.TableTunnel;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.client.ddl.DdlManager;
import com.gotocompany.depot.maxcompute.client.insert.InsertManager;
import com.gotocompany.depot.maxcompute.client.insert.InsertManagerFactory;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import com.gotocompany.depot.metrics.StatsDReporter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxComputeClient {
    private static final Logger log = LoggerFactory.getLogger(MaxComputeClient.class);
    private Odps odps;
    private MaxComputeSinkConfig maxComputeSinkConfig;
    private TableTunnel tableTunnel;
    private DdlManager ddlManager;
    private MaxComputeMetrics maxComputeMetrics;
    private Instrumentation instrumentation;

    public MaxComputeClient(MaxComputeSinkConfig maxComputeSinkConfig, StatsDReporter statsDReporter, MaxComputeMetrics maxComputeMetrics) {
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.instrumentation = new Instrumentation(statsDReporter, this.getClass());
        this.odps = this.initializeOdps();
        this.tableTunnel = new TableTunnel(this.odps);
        if (StringUtils.isNotEmpty((CharSequence)maxComputeSinkConfig.getMaxComputeTunnelUrl())) {
            this.tableTunnel.setEndpoint(maxComputeSinkConfig.getMaxComputeTunnelUrl());
        }
        this.maxComputeMetrics = maxComputeMetrics;
        this.ddlManager = this.initializeDdlManager();
    }

    public TableSchema getLatestTableSchema() {
        return this.odps.tables().get(this.maxComputeSinkConfig.getMaxComputeProjectId(), this.maxComputeSinkConfig.getMaxComputeSchema(), this.maxComputeSinkConfig.getMaxComputeTableName()).getSchema();
    }

    public void createOrUpdateTable(TableSchema tableSchema) throws OdpsException {
        this.ddlManager.createOrUpdateTable(tableSchema);
    }

    public InsertManager createInsertManager() {
        return InsertManagerFactory.createInsertManager(this.maxComputeSinkConfig, this.tableTunnel, this.instrumentation, this.maxComputeMetrics);
    }

    private Odps initializeOdps() {
        AliyunAccount account = new AliyunAccount(this.maxComputeSinkConfig.getMaxComputeAccessId(), this.maxComputeSinkConfig.getMaxComputeAccessKey());
        Odps odpsClient = new Odps((Account)account);
        odpsClient.setDefaultProject(this.maxComputeSinkConfig.getMaxComputeProjectId());
        odpsClient.setEndpoint(this.maxComputeSinkConfig.getMaxComputeOdpsUrl());
        odpsClient.setCurrentSchema(this.maxComputeSinkConfig.getMaxComputeSchema());
        odpsClient.setGlobalSettings(this.maxComputeSinkConfig.getOdpsGlobalSettings());
        return odpsClient;
    }

    private DdlManager initializeDdlManager() {
        return new DdlManager(this.odps, this.maxComputeSinkConfig, this.instrumentation, this.maxComputeMetrics);
    }

    public MaxComputeClient(Odps odps, MaxComputeSinkConfig maxComputeSinkConfig, TableTunnel tableTunnel, DdlManager ddlManager, MaxComputeMetrics maxComputeMetrics, Instrumentation instrumentation) {
        this.odps = odps;
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.tableTunnel = tableTunnel;
        this.ddlManager = ddlManager;
        this.maxComputeMetrics = maxComputeMetrics;
        this.instrumentation = instrumentation;
    }

    public MaxComputeClient() {
    }
}

