/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.client.insert.session;

import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import java.time.Instant;

public final class StreamingSessionManager {
    private final LoadingCache<String, TableTunnel.StreamUploadSession> sessionCache;

    private StreamingSessionManager(LoadingCache<String, TableTunnel.StreamUploadSession> loadingCache) {
        this.sessionCache = loadingCache;
    }

    public static StreamingSessionManager createNonPartitioned(final TableTunnel tableTunnel, final MaxComputeSinkConfig maxComputeSinkConfig, final Instrumentation instrumentation, final MaxComputeMetrics maxComputeMetrics) {
        CacheLoader<String, TableTunnel.StreamUploadSession> cacheLoader = new CacheLoader<String, TableTunnel.StreamUploadSession>(){

            public TableTunnel.StreamUploadSession load(String partitionSpecKey) throws TunnelException {
                return StreamingSessionManager.buildStreamSession(StreamingSessionManager.getBaseStreamSessionBuilder(tableTunnel, maxComputeSinkConfig), instrumentation, maxComputeMetrics);
            }
        };
        return new StreamingSessionManager((LoadingCache<String, TableTunnel.StreamUploadSession>)CacheBuilder.newBuilder().maximumSize((long)maxComputeSinkConfig.getStreamingInsertMaximumSessionCount()).build((CacheLoader)cacheLoader));
    }

    public static StreamingSessionManager createPartitioned(final TableTunnel tableTunnel, final MaxComputeSinkConfig maxComputeSinkConfig, final Instrumentation instrumentation, final MaxComputeMetrics maxComputeMetrics) {
        CacheLoader<String, TableTunnel.StreamUploadSession> cacheLoader = new CacheLoader<String, TableTunnel.StreamUploadSession>(){

            public TableTunnel.StreamUploadSession load(String partitionSpecKey) throws TunnelException {
                return StreamingSessionManager.buildStreamSession(StreamingSessionManager.getBaseStreamSessionBuilder(tableTunnel, maxComputeSinkConfig).setCreatePartition(true).setPartitionSpec(partitionSpecKey), instrumentation, maxComputeMetrics);
            }
        };
        return new StreamingSessionManager((LoadingCache<String, TableTunnel.StreamUploadSession>)CacheBuilder.newBuilder().maximumSize((long)maxComputeSinkConfig.getStreamingInsertMaximumSessionCount()).build((CacheLoader)cacheLoader));
    }

    public TableTunnel.StreamUploadSession getSession(String partitionSpec) {
        return (TableTunnel.StreamUploadSession)this.sessionCache.getUnchecked((Object)partitionSpec);
    }

    @Deprecated
    public void refreshSession(String partitionSpec) {
        this.sessionCache.refresh((Object)partitionSpec);
    }

    @Deprecated
    public void refreshAllSessions() {
        this.sessionCache.asMap().keySet().forEach(arg_0 -> this.sessionCache.refresh(arg_0));
    }

    private static TableTunnel.StreamUploadSession buildStreamSession(TableTunnel.StreamUploadSession.Builder streamUploadSessionBuilder, Instrumentation instrumentation, MaxComputeMetrics maxComputeMetrics) throws TunnelException {
        Instant start = Instant.now();
        TableTunnel.StreamUploadSession streamUploadSession = streamUploadSessionBuilder.build();
        instrumentation.captureDurationSince(maxComputeMetrics.getMaxComputeStreamingInsertSessionInitializationLatency(), start, new String[0]);
        instrumentation.incrementCounter(maxComputeMetrics.getMaxComputeStreamingInsertSessionCreatedCount(), new String[0]);
        return streamUploadSession;
    }

    private static TableTunnel.StreamUploadSession.Builder getBaseStreamSessionBuilder(TableTunnel tableTunnel, MaxComputeSinkConfig maxComputeSinkConfig) {
        return tableTunnel.buildStreamUploadSession(maxComputeSinkConfig.getMaxComputeProjectId(), maxComputeSinkConfig.getMaxComputeTableName()).allowSchemaMismatch(maxComputeSinkConfig.isAllowSchemaMismatchEnabled()).setSlotNum(maxComputeSinkConfig.getStreamingInsertTunnelSlotCountPerSession());
    }
}

