/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter;

import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.protobuf.Message;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.converter.ProtobufMaxComputeConverter;
import com.gotocompany.depot.maxcompute.model.ProtoPayload;
import com.gotocompany.depot.maxcompute.util.LocalDateTimeValidator;

public class TimestampNTZProtobufMaxComputeConverter
implements ProtobufMaxComputeConverter {
    private static final String SECONDS = "seconds";
    private static final String NANOS = "nanos";
    private final LocalDateTimeValidator localDateTimeValidator;
    private final boolean isIgnoreNegativeSecondTimestampEnabled;

    public TimestampNTZProtobufMaxComputeConverter(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.localDateTimeValidator = new LocalDateTimeValidator(maxComputeSinkConfig);
        this.isIgnoreNegativeSecondTimestampEnabled = maxComputeSinkConfig.isIgnoreNegativeSecondTimestampEnabled();
    }

    @Override
    public TypeInfo convertSingularTypeInfo(ProtoPayload protoPayload) {
        return TypeInfoFactory.TIMESTAMP_NTZ;
    }

    @Override
    public Object convertSingularPayload(ProtoPayload protoPayload) {
        Message message = (Message)protoPayload.getParsedObject();
        long seconds = (Long)message.getField(message.getDescriptorForType().findFieldByName(SECONDS));
        if (seconds < 0L && this.isIgnoreNegativeSecondTimestampEnabled) {
            return null;
        }
        int nanos = (Integer)message.getField(message.getDescriptorForType().findFieldByName(NANOS));
        return this.localDateTimeValidator.parseAndValidate(seconds, nanos, protoPayload.getFieldDescriptor().getName(), protoPayload.isRootLevel());
    }
}

