/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter.mapper;

import com.aliyun.odps.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.converter.mapper.ProtoPrimitiveDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.casted.DoubleToDecimalDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.casted.FloatToDecimalDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.casted.FloatToDoubleDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.casted.IntegerToBigintDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.noncasted.DoubleDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.noncasted.FloatDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.noncasted.IntegerDataTypeMapper;
import com.gotocompany.depot.maxcompute.converter.mapper.noncasted.NonNumericDataTypeMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ProtoPrimitiveDataTypeMapperFactory {
    private final ProtoPrimitiveDataTypeMapper nonNumericDataTypeMapper;
    private final ProtoPrimitiveDataTypeMapper integerProtoPrimitiveDataTypeMapper;
    private final ProtoPrimitiveDataTypeMapper floatProtoPrimitiveDataTypeMapper;
    private final ProtoPrimitiveDataTypeMapper doubleProtoPrimitiveDataTypeMapper;

    public ProtoPrimitiveDataTypeMapperFactory(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.nonNumericDataTypeMapper = new NonNumericDataTypeMapper();
        this.integerProtoPrimitiveDataTypeMapper = maxComputeSinkConfig.isProtoIntegerTypesToBigintEnabled() ? new IntegerToBigintDataTypeMapper() : new IntegerDataTypeMapper();
        ProtoPrimitiveDataTypeMapper protoPrimitiveDataTypeMapper = this.doubleProtoPrimitiveDataTypeMapper = maxComputeSinkConfig.isProtoDoubleToDecimalEnabled() ? new DoubleToDecimalDataTypeMapper(maxComputeSinkConfig) : new DoubleDataTypeMapper();
        this.floatProtoPrimitiveDataTypeMapper = maxComputeSinkConfig.isProtoFloatTypeToDoubleEnabled() ? new FloatToDoubleDataTypeMapper() : (maxComputeSinkConfig.isProtoFloatTypeToDecimalEnabled() ? new FloatToDecimalDataTypeMapper(maxComputeSinkConfig) : new FloatDataTypeMapper());
    }

    public Map<Descriptors.FieldDescriptor.Type, TypeInfo> getProtoTypeMap() {
        return ProtoPrimitiveDataTypeMapperFactory.mergeMaps(ImmutableList.of(this.nonNumericDataTypeMapper.getProtoTypeMap(), this.integerProtoPrimitiveDataTypeMapper.getProtoTypeMap(), this.floatProtoPrimitiveDataTypeMapper.getProtoTypeMap(), this.doubleProtoPrimitiveDataTypeMapper.getProtoTypeMap()));
    }

    public Map<Descriptors.FieldDescriptor.Type, Function<Object, Object>> getProtoPayloadMapperMap() {
        return ProtoPrimitiveDataTypeMapperFactory.mergeMaps(ImmutableList.of(this.nonNumericDataTypeMapper.getProtoPayloadMapperMap(), this.integerProtoPrimitiveDataTypeMapper.getProtoPayloadMapperMap(), this.floatProtoPrimitiveDataTypeMapper.getProtoPayloadMapperMap(), this.doubleProtoPrimitiveDataTypeMapper.getProtoPayloadMapperMap()));
    }

    private static <K, V> Map<K, V> mergeMaps(List<Map<K, V>> maps) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map<K, V> map : maps) {
            builder.putAll(map);
        }
        return builder.build();
    }

    public ProtoPrimitiveDataTypeMapperFactory(ProtoPrimitiveDataTypeMapper nonNumericDataTypeMapper, ProtoPrimitiveDataTypeMapper integerProtoPrimitiveDataTypeMapper, ProtoPrimitiveDataTypeMapper floatProtoPrimitiveDataTypeMapper, ProtoPrimitiveDataTypeMapper doubleProtoPrimitiveDataTypeMapper) {
        this.nonNumericDataTypeMapper = nonNumericDataTypeMapper;
        this.integerProtoPrimitiveDataTypeMapper = integerProtoPrimitiveDataTypeMapper;
        this.floatProtoPrimitiveDataTypeMapper = floatProtoPrimitiveDataTypeMapper;
        this.doubleProtoPrimitiveDataTypeMapper = doubleProtoPrimitiveDataTypeMapper;
    }
}

