/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.converter.record;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ReorderableRecord;
import com.aliyun.odps.exceptions.SchemaMismatchException;
import com.aliyun.odps.exceptions.SchemaMismatchRuntimeException;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.exception.InvalidMessageException;
import com.gotocompany.depot.exception.UnknownFieldsException;
import com.gotocompany.depot.maxcompute.converter.record.MessageRecordConverter;
import com.gotocompany.depot.maxcompute.model.MaxComputeSchema;
import com.gotocompany.depot.maxcompute.model.RecordWrapper;
import com.gotocompany.depot.maxcompute.model.RecordWrappers;
import com.gotocompany.depot.maxcompute.record.RecordDecorator;
import com.gotocompany.depot.maxcompute.schema.MaxComputeSchemaCache;
import com.gotocompany.depot.message.Message;
import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoMessageRecordConverter
implements MessageRecordConverter {
    private static final Logger log = LoggerFactory.getLogger(ProtoMessageRecordConverter.class);
    private final RecordDecorator recordDecorator;
    private final MaxComputeSchemaCache maxComputeSchemaCache;

    @Override
    public RecordWrappers convert(List<Message> messages) {
        MaxComputeSchema maxComputeSchema = this.maxComputeSchemaCache.getMaxComputeSchema();
        RecordWrappers recordWrappers = new RecordWrappers();
        IntStream.range(0, messages.size()).forEach(index -> {
            ReorderableRecord record = new ReorderableRecord(maxComputeSchema.getTableSchema());
            RecordWrapper recordWrapper = new RecordWrapper((Record)record, index, null, null);
            try {
                recordWrappers.addValidRecord(this.recordDecorator.decorate(recordWrapper, (Message)messages.get(index)));
            }
            catch (SchemaMismatchException | SchemaMismatchRuntimeException e) {
                log.debug("Schema mismatch error while converting message to record", e);
                recordWrappers.addInvalidRecord(this.toErrorRecordWrapper(recordWrapper, new ErrorInfo((Exception)e, ErrorType.SINK_NON_RETRYABLE_ERROR)));
            }
            catch (IOException e) {
                log.debug("Deserialization error while converting message to record", (Throwable)e);
                recordWrappers.addInvalidRecord(this.toErrorRecordWrapper(recordWrapper, new ErrorInfo(e, ErrorType.DESERIALIZATION_ERROR)));
            }
            catch (UnknownFieldsException e) {
                log.debug("Unknown field message error while converting message to record", (Throwable)e);
                recordWrappers.addInvalidRecord(this.toErrorRecordWrapper(recordWrapper, new ErrorInfo(e, ErrorType.UNKNOWN_FIELDS_ERROR)));
            }
            catch (EmptyMessageException | InvalidMessageException e) {
                log.debug("Invalid message error while converting message to record", (Throwable)e);
                recordWrappers.addInvalidRecord(this.toErrorRecordWrapper(recordWrapper, new ErrorInfo(e, ErrorType.INVALID_MESSAGE_ERROR)));
            }
            catch (Exception e) {
                log.debug("Unknown error while converting message to record", (Throwable)e);
                recordWrappers.addInvalidRecord(this.toErrorRecordWrapper(recordWrapper, new ErrorInfo(e, ErrorType.SINK_UNKNOWN_ERROR)));
            }
        });
        return recordWrappers;
    }

    private RecordWrapper toErrorRecordWrapper(RecordWrapper recordWrapper, ErrorInfo e) {
        return new RecordWrapper(null, recordWrapper.getIndex(), e, recordWrapper.getPartitionSpec());
    }

    public ProtoMessageRecordConverter(RecordDecorator recordDecorator, MaxComputeSchemaCache maxComputeSchemaCache) {
        this.recordDecorator = recordDecorator;
        this.maxComputeSchemaCache = maxComputeSchemaCache;
    }
}

