/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.maxcompute.client.MaxComputeClient;
import com.gotocompany.depot.maxcompute.converter.ProtobufConverterOrchestrator;
import com.gotocompany.depot.maxcompute.exception.MaxComputeTableOperationException;
import com.gotocompany.depot.maxcompute.model.MaxComputeSchema;
import com.gotocompany.depot.maxcompute.schema.MaxComputeSchemaBuilder;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.message.proto.ProtoMessageParser;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxComputeSchemaCache
extends DepotStencilUpdateListener {
    private static final Logger log = LoggerFactory.getLogger(MaxComputeSchemaCache.class);
    private final MaxComputeSchemaBuilder maxComputeSchemaBuilder;
    private final SinkConfig sinkConfig;
    private final ProtobufConverterOrchestrator protobufConverterOrchestrator;
    private final MaxComputeClient maxComputeClient;
    private MaxComputeSchema maxComputeSchema;

    public MaxComputeSchemaCache(MaxComputeSchemaBuilder maxComputeSchemaBuilder, SinkConfig sinkConfig, ProtobufConverterOrchestrator protobufConverterOrchestrator, MaxComputeClient maxComputeClient) {
        this.maxComputeSchemaBuilder = maxComputeSchemaBuilder;
        this.sinkConfig = sinkConfig;
        this.protobufConverterOrchestrator = protobufConverterOrchestrator;
        this.maxComputeClient = maxComputeClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxComputeSchema getMaxComputeSchema() {
        MaxComputeSchemaCache maxComputeSchemaCache = this;
        synchronized (maxComputeSchemaCache) {
            if (this.maxComputeSchema == null) {
                this.updateSchema();
            }
        }
        return this.maxComputeSchema;
    }

    @Override
    public synchronized void onSchemaUpdate(Map<String, Descriptors.Descriptor> newDescriptor) {
        Descriptors.Descriptor descriptor = newDescriptor.get(this.getSchemaClass());
        this.updateMaxComputeTableSchema(descriptor);
    }

    @Override
    public synchronized void updateSchema() {
        Map<String, Descriptors.Descriptor> descriptorMap = ((ProtoMessageParser)this.getMessageParser()).getDescriptorMap();
        Descriptors.Descriptor descriptor = descriptorMap.get(this.getSchemaClass());
        this.updateMaxComputeTableSchema(descriptor);
    }

    private void updateMaxComputeTableSchema(Descriptors.Descriptor descriptor) {
        MaxComputeSchema localSchema = this.maxComputeSchemaBuilder.build(descriptor);
        try {
            log.info("Upserting MaxCompute table schema");
            this.maxComputeClient.createOrUpdateTable(localSchema.getTableSchema());
            log.info("MaxCompute table upserted successfully");
            TableSchema serverSideTableSchema = this.maxComputeClient.getLatestTableSchema();
            this.maxComputeSchema = new MaxComputeSchema(serverSideTableSchema, localSchema.getMetadataColumns());
        }
        catch (OdpsException e) {
            throw new MaxComputeTableOperationException("Error while updating MaxCompute table", (Exception)((Object)e));
        }
        finally {
            log.info("Clearing protobuf converter cache");
            this.protobufConverterOrchestrator.clearCache();
        }
    }

    private String getSchemaClass() {
        return this.sinkConfig.getSinkConnectorSchemaMessageMode() == SinkConnectorSchemaMessageMode.LOG_MESSAGE ? this.sinkConfig.getSinkConnectorSchemaProtoMessageClass() : this.sinkConfig.getSinkConnectorSchemaProtoKeyClass();
    }
}

