/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.gotocompany.depot.maxcompute.model.MaxComputeColumnDetail;
import com.gotocompany.depot.maxcompute.util.TypeInfoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@Deprecated
public class SchemaDifferenceUtils {
    private static final String ALTER_TABLE_QUERY_TEMPLATE = "ALTER TABLE %s.%s ADD COLUMN IF NOT EXISTS %s;";

    public static List<String> getSchemaDifferenceSql(TableSchema oldSchema, TableSchema newSchema, String schemaName, String tableName) {
        List<MaxComputeColumnDetail> maxComputeColumnDetailDifference = SchemaDifferenceUtils.getMaxComputeColumnDetailDifference(oldSchema, newSchema, tableName);
        return maxComputeColumnDetailDifference.stream().map(maxComputeColumnDetail -> String.format(ALTER_TABLE_QUERY_TEMPLATE, schemaName, tableName, maxComputeColumnDetail.getDDL()).toLowerCase()).collect(Collectors.toList());
    }

    private static List<MaxComputeColumnDetail> getMaxComputeColumnDetailDifference(TableSchema oldSchema, TableSchema newSchema, String tableName) {
        Map<String, MaxComputeColumnDetail> oldMaxComputeColumnDetail = SchemaDifferenceUtils.buildMaxComputeColumnDetailMap(oldSchema);
        Map<String, MaxComputeColumnDetail> newMaxComputeColumnDetail = SchemaDifferenceUtils.buildMaxComputeColumnDetailMap(newSchema);
        Iterator<Map.Entry<String, MaxComputeColumnDetail>> newMaxComputeColumnDetailIterator = newMaxComputeColumnDetail.entrySet().iterator();
        ArrayList<MaxComputeColumnDetail> changedMetadata = new ArrayList<MaxComputeColumnDetail>();
        while (newMaxComputeColumnDetailIterator.hasNext()) {
            Map.Entry<String, MaxComputeColumnDetail> entry = newMaxComputeColumnDetailIterator.next();
            String columnName = entry.getKey();
            MaxComputeColumnDetail oldMetadata = oldMaxComputeColumnDetail.get(columnName);
            if (!Objects.isNull(oldMetadata) && (TypeInfoUtils.isPrimitiveType(oldMetadata.getTypeInfo()) || TypeInfoUtils.isPrimitiveArrayType(oldMetadata.getTypeInfo())) && !entry.getValue().getTypeInfo().equals(oldMetadata.getTypeInfo())) {
                throw new UnsupportedOperationException(String.format("Cannot change column type for column %s from %s to %s", columnName, oldMetadata.getTypeInfo(), entry.getValue().getTypeInfo()));
            }
            if (!Objects.isNull(oldMetadata)) continue;
            changedMetadata.add(entry.getValue());
            if (!TypeInfoUtils.isStructType(entry.getValue().getTypeInfo()) && !TypeInfoUtils.isStructArrayType(entry.getValue().getTypeInfo())) continue;
            SchemaDifferenceUtils.skipStructFields(entry, newMaxComputeColumnDetailIterator);
        }
        return changedMetadata;
    }

    private static void skipStructFields(Map.Entry<String, MaxComputeColumnDetail> entry, Iterator<Map.Entry<String, MaxComputeColumnDetail>> newMaxComputeColumnDetailIterator) {
        StructTypeInfo structTypeInfo = TypeInfoUtils.isStructType(entry.getValue().getTypeInfo()) ? (StructTypeInfo)entry.getValue().getTypeInfo() : (StructTypeInfo)((ArrayTypeInfo)entry.getValue().getTypeInfo()).getElementTypeInfo();
        for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
            newMaxComputeColumnDetailIterator.next();
        }
    }

    private static Map<String, MaxComputeColumnDetail> buildMaxComputeColumnDetailMap(TableSchema schema) {
        TreeMap<String, MaxComputeColumnDetail> maxComputeColumnDetailMap = new TreeMap<String, MaxComputeColumnDetail>();
        schema.getColumns().forEach(column -> SchemaDifferenceUtils.fieldMetadataHelper(column.getTypeInfo(), "", column.getName(), maxComputeColumnDetailMap, false));
        return maxComputeColumnDetailMap;
    }

    private static void fieldMetadataHelper(TypeInfo typeInfo, String prefix, String name, Map<String, MaxComputeColumnDetail> result, boolean isArrayElement) {
        if (TypeInfoUtils.isPrimitiveType(typeInfo) || TypeInfoUtils.isPrimitiveArrayType(typeInfo)) {
            result.put(SchemaDifferenceUtils.getPathName(prefix, name, isArrayElement), new MaxComputeColumnDetail(prefix, name, typeInfo, isArrayElement));
        }
        if (TypeInfoUtils.isStructType(typeInfo) || TypeInfoUtils.isStructArrayType(typeInfo)) {
            StructTypeInfo structTypeInfo = TypeInfoUtils.isStructType(typeInfo) ? (StructTypeInfo)typeInfo : (StructTypeInfo)((ArrayTypeInfo)typeInfo).getElementTypeInfo();
            result.put(SchemaDifferenceUtils.getPathName(prefix, name, isArrayElement), new MaxComputeColumnDetail(prefix, name, typeInfo, isArrayElement));
            for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                TypeInfo fieldType = (TypeInfo)structTypeInfo.getFieldTypeInfos().get(i);
                String fieldName = (String)structTypeInfo.getFieldNames().get(i);
                SchemaDifferenceUtils.fieldMetadataHelper(fieldType, SchemaDifferenceUtils.getPathName(prefix, name, isArrayElement), fieldName, result, TypeInfoUtils.isStructArrayType(typeInfo));
            }
        }
    }

    private static String getPathName(String prefix, String name, boolean isArrayElement) {
        return StringUtils.isBlank((String)prefix) ? String.format("`%s`", name).toLowerCase() : String.format("%s%s.`%s`", prefix, isArrayElement ? ".element" : "", name).toLowerCase();
    }
}

