/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.schema.validator;

import com.aliyun.odps.TableSchema;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class TableValidator {
    private final MaxComputeSinkConfig maxComputeSinkConfig;
    private final Pattern validTableNamePattern;

    public TableValidator(MaxComputeSinkConfig maxComputeSinkConfig) {
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.validTableNamePattern = Pattern.compile(maxComputeSinkConfig.getTableValidatorNameRegex());
    }

    public void validate(String tableName, Long lifecycleDays, TableSchema tableSchema) {
        ArrayList<String> errorHolder = new ArrayList<String>();
        this.validateTableName(tableName, errorHolder);
        this.validateLifecycleDays(lifecycleDays, errorHolder);
        this.validateTableSchema(tableSchema, errorHolder);
        if (!errorHolder.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)", ", errorHolder));
        }
    }

    private void validateTableName(String tableName, List<String> errorHolder) {
        if (!this.validTableNamePattern.matcher(tableName).matches()) {
            errorHolder.add("Table name should match the pattern: " + this.validTableNamePattern.pattern());
        }
    }

    private void validateLifecycleDays(Long lifecycleDays, List<String> errorHolder) {
        if (Objects.nonNull(lifecycleDays) && lifecycleDays < 0L) {
            errorHolder.add("Lifecycle days should be a positive integer");
        }
    }

    private void validateTableSchema(TableSchema tableSchema, List<String> errorHolder) {
        if (tableSchema.getAllColumns().size() > this.maxComputeSinkConfig.getTableValidatorMaxColumnsPerTable()) {
            errorHolder.add("Table schema should have less or equal than " + this.maxComputeSinkConfig.getTableValidatorMaxColumnsPerTable() + " columns");
        }
        if (tableSchema.getPartitionColumns().size() > this.maxComputeSinkConfig.getTableValidatorMaxPartitionKeysPerTable()) {
            errorHolder.add("Table schema should have less or equal than " + this.maxComputeSinkConfig.getTableValidatorMaxPartitionKeysPerTable() + " partition keys");
        }
    }
}

