/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message;

import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.json.JsonMessageParser;
import com.gotocompany.depot.message.proto.ProtoMessageParser;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.JsonParserMetrics;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;

public class MessageParserFactory {
    public static MessageParser getParser(SinkConfig config, StatsDReporter statsDReporter, DepotStencilUpdateListener depotStencilUpdateListener) {
        switch (config.getSinkConnectorSchemaDataType()) {
            case JSON: {
                return new JsonMessageParser(config, new Instrumentation(statsDReporter, JsonMessageParser.class), new JsonParserMetrics(config));
            }
            case PROTOBUF: {
                return new ProtoMessageParser(config, statsDReporter, depotStencilUpdateListener);
            }
        }
        throw new IllegalArgumentException("Schema Type is not supported");
    }

    public static MessageParser getParser(SinkConfig config, StatsDReporter statsDReporter) {
        return MessageParserFactory.getParser(config, statsDReporter, null);
    }
}

