/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageUtils;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.message.proto.ProtoField;
import com.gotocompany.depot.message.proto.ProtoFieldParser;
import com.gotocompany.depot.message.proto.ProtoJsonProvider;
import com.gotocompany.depot.message.proto.ProtoParsedMessage;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;
import com.gotocompany.depot.utils.StencilUtils;
import com.gotocompany.stencil.StencilClientFactory;
import com.gotocompany.stencil.client.StencilClient;
import com.gotocompany.stencil.config.StencilConfig;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoMessageParser
implements MessageParser {
    private static final Logger log = LoggerFactory.getLogger(ProtoMessageParser.class);
    private final StencilClient stencilClient;
    private final ProtoFieldParser protoMappingParser = new ProtoFieldParser();
    private final Configuration jsonPathConfig;

    public ProtoMessageParser(SinkConfig sinkConfig, StatsDReporter reporter, DepotStencilUpdateListener protoUpdateListener) {
        StencilConfig stencilConfig = StencilUtils.getStencilConfig(sinkConfig, reporter.getClient(), protoUpdateListener);
        this.stencilClient = sinkConfig.isSchemaRegistryStencilEnable() != false ? StencilClientFactory.getClient((String)sinkConfig.getSchemaRegistryStencilUrls(), (StencilConfig)stencilConfig) : StencilClientFactory.getClient();
        this.jsonPathConfig = Configuration.builder().jsonProvider((JsonProvider)new ProtoJsonProvider(sinkConfig)).build();
    }

    public ProtoMessageParser(StencilClient stencilClient, Configuration jsonPathConfig) {
        this.jsonPathConfig = jsonPathConfig;
        this.stencilClient = stencilClient;
    }

    @Override
    public ParsedMessage parse(Message message, SinkConnectorSchemaMessageMode type, String schemaClass) throws IOException {
        byte[] payload;
        if (type == null) {
            throw new IOException("parser mode not defined");
        }
        MessageUtils.validate(message, byte[].class);
        switch (type) {
            case LOG_MESSAGE: {
                payload = (byte[])message.getLogMessage();
                break;
            }
            case LOG_KEY: {
                payload = (byte[])message.getLogKey();
                break;
            }
            default: {
                throw new ConfigurationException("Schema type not supported");
            }
        }
        if (payload == null || payload.length == 0) {
            log.info("empty message found {}", (Object)message.getMetadataString());
            throw new EmptyMessageException();
        }
        DynamicMessage dynamicMessage = this.stencilClient.parse(schemaClass, payload);
        return new ProtoParsedMessage(dynamicMessage, this.jsonPathConfig);
    }

    public Map<String, Descriptors.Descriptor> getDescriptorMap() {
        return this.stencilClient.getAll();
    }

    @Override
    public void refresh(String schemaClass) {
        this.stencilClient.get(schemaClass);
    }

    private Map<String, String> getTypeNameToPackageNameMap(Map<String, Descriptors.Descriptor> descriptors) {
        return descriptors.entrySet().stream().filter(this.distinctByFullName(t -> ((Descriptors.Descriptor)t.getValue()).getFullName())).collect(Collectors.toMap(mapEntry -> String.format(".%s", ((Descriptors.Descriptor)mapEntry.getValue()).getFullName()), Map.Entry::getKey));
    }

    private <T> Predicate<T> distinctByFullName(Function<? super T, Object> keyExtractor) {
        HashSet objects = new HashSet();
        return t -> objects.add(keyExtractor.apply(t));
    }

    public ProtoField getProtoField(String schemaClass, Map<String, Descriptors.Descriptor> newDescriptors) throws IOException {
        ProtoField protoField = new ProtoField();
        protoField = this.protoMappingParser.parseFields(protoField, schemaClass, newDescriptors, this.getTypeNameToPackageNameMap(newDescriptors));
        return protoField;
    }

    public ProtoField getProtoField(String schemaClass) throws IOException {
        ProtoField protoField = new ProtoField();
        protoField = this.protoMappingParser.parseFields(protoField, schemaClass, this.getDescriptorMap(), this.getTypeNameToPackageNameMap(this.getDescriptorMap()));
        return protoField;
    }

    public Descriptors.Descriptor getDescriptor(String schemaClass) {
        return this.stencilClient.get(schemaClass);
    }
}

