/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.exception.UnknownFieldsException;
import com.gotocompany.depot.message.LogicalValue;
import com.gotocompany.depot.message.MessageUtils;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.ProtoUnknownFieldValidationType;
import com.gotocompany.depot.message.proto.ProtoLogicalValue;
import com.gotocompany.depot.message.proto.UnknownProtoFields;
import com.gotocompany.depot.schema.Schema;
import com.gotocompany.depot.schema.SchemaField;
import com.gotocompany.depot.schema.proto.ProtoSchema;
import com.gotocompany.depot.schema.proto.ProtoSchemaField;
import com.gotocompany.depot.utils.ProtoUtils;
import com.jayway.jsonpath.Configuration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoParsedMessage
implements ParsedMessage {
    private static final Logger log = LoggerFactory.getLogger(ProtoParsedMessage.class);
    private final Message dynamicMessage;
    private final Configuration jsonPathConfig;

    public ProtoParsedMessage(DynamicMessage dynamicMessage, Configuration jsonPathConfig) {
        this.dynamicMessage = dynamicMessage;
        this.jsonPathConfig = jsonPathConfig;
    }

    public ProtoParsedMessage(Message dynamicMessage, Configuration jsonPathConfig) {
        this.dynamicMessage = dynamicMessage;
        this.jsonPathConfig = jsonPathConfig;
    }

    public String toString() {
        return this.dynamicMessage.toString();
    }

    @Override
    public Object getRaw() {
        return this.dynamicMessage;
    }

    @Override
    public JSONObject toJson() {
        String json;
        try {
            json = JsonFormat.printer().print((MessageOrBuilder)this.dynamicMessage);
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            throw new DeserializerException(e.getMessage());
        }
        return new JSONObject(json);
    }

    @Override
    public void validate(ProtoUnknownFieldValidationType protoUnknownFieldValidationType) {
        if (ProtoUtils.hasUnknownField(this.dynamicMessage, protoUnknownFieldValidationType)) {
            log.error("Unknown fields {}", (Object)UnknownProtoFields.toString(this.dynamicMessage.toByteArray()));
            throw new UnknownFieldsException(this.dynamicMessage);
        }
    }

    private Object getProtoValue(Descriptors.FieldDescriptor fd, Object value) {
        switch (fd.getJavaType()) {
            case ENUM: {
                return value.toString();
            }
            case MESSAGE: {
                return new ProtoParsedMessage((Message)value, this.jsonPathConfig);
            }
        }
        return value;
    }

    @Override
    public Map<SchemaField, Object> getFields() {
        return this.dynamicMessage.getDescriptorForType().getFields().stream().filter(fd -> {
            Object value = this.dynamicMessage.getField(fd);
            if (value == null) {
                return false;
            }
            if (fd.isRepeated()) {
                return !((List)value).isEmpty();
            }
            return !value.toString().isEmpty();
        }).collect(Collectors.toMap(ProtoSchemaField::new, fd -> {
            Object value = this.dynamicMessage.getField(fd);
            if (fd.isRepeated()) {
                return ((List)value).stream().map(v -> this.getProtoValue((Descriptors.FieldDescriptor)fd, v)).collect(Collectors.toList());
            }
            return this.getProtoValue((Descriptors.FieldDescriptor)fd, value);
        }));
    }

    @Override
    public Object getFieldByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid field config : name can not be empty");
        }
        return MessageUtils.getFieldFromJsonObject(name, this.dynamicMessage, this.jsonPathConfig);
    }

    @Override
    public Schema getSchema() {
        return new ProtoSchema(this.dynamicMessage.getDescriptorForType());
    }

    @Override
    public LogicalValue getLogicalValue() {
        return new ProtoLogicalValue(this.dynamicMessage, this.getSchema());
    }
}

