/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto.converter.fields;

import com.google.protobuf.Descriptors;
import com.gotocompany.depot.message.proto.converter.fields.ProtoField;
import java.util.Collection;
import java.util.stream.Collectors;

public class FloatProtoField
implements ProtoField {
    private final Object fieldValue;
    private final Descriptors.FieldDescriptor descriptor;

    public FloatProtoField(Descriptors.FieldDescriptor descriptor, Object fieldValue) {
        this.descriptor = descriptor;
        this.fieldValue = fieldValue;
    }

    @Override
    public Object getValue() {
        if (this.fieldValue instanceof Collection) {
            return ((Collection)this.fieldValue).stream().map(this::getValue).collect(Collectors.toList());
        }
        return this.getValue(this.fieldValue);
    }

    public Double getValue(Object field) {
        boolean valid;
        double val = Double.parseDouble(field.toString());
        boolean bl = valid = !Double.isInfinite(val) && !Double.isNaN(val);
        if (!valid) {
            throw new IllegalArgumentException("Float/double value is not valid");
        }
        return val;
    }

    @Override
    public boolean matches() {
        return this.descriptor.getType() == Descriptors.FieldDescriptor.Type.FLOAT || this.descriptor.getType() == Descriptors.FieldDescriptor.Type.DOUBLE;
    }
}

