/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.metrics;

import com.gotocompany.depot.config.MetricsConfig;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDReporterBuilder {
    private static final Logger log = LoggerFactory.getLogger(StatsDReporterBuilder.class);
    private MetricsConfig metricsConfig;
    private String[] extraTags;

    private static <T> T[] append(T[] arr, T lastElement) {
        int length = arr.length;
        arr = Arrays.copyOf(arr, length + 1);
        arr[length] = lastElement;
        return arr;
    }

    public static StatsDReporterBuilder builder() {
        return new StatsDReporterBuilder();
    }

    public StatsDReporterBuilder withMetricConfig(MetricsConfig config) {
        this.metricsConfig = config;
        return this;
    }

    public StatsDReporterBuilder withExtraTags(String ... tags) {
        this.extraTags = tags;
        return this;
    }

    private static <T> T[] append(T[] arr, T[] second) {
        int length = arr.length;
        arr = Arrays.copyOf(arr, length + second.length);
        System.arraycopy(second, 0, arr, length, second.length);
        return arr;
    }

    public StatsDReporter build() {
        StatsDClient statsDClient = this.buildStatsDClient();
        return new StatsDReporter(statsDClient, StatsDReporterBuilder.append(this.metricsConfig.getMetricStatsDTags().split(","), this.extraTags));
    }

    private StatsDClient buildStatsDClient() {
        NoOpStatsDClient statsDClient;
        try {
            statsDClient = new NonBlockingStatsDClientBuilder().hostname(this.metricsConfig.getMetricStatsDHost()).port(this.metricsConfig.getMetricStatsDPort().intValue()).build();
            log.info("NonBlocking StatsD client connection established");
        }
        catch (Exception e) {
            log.warn("Exception on creating StatsD client, disabling StatsD and Audit client", (Throwable)e);
            log.warn("Application is running without collecting any metrics!!!!!!!!");
            statsDClient = new NoOpStatsDClient();
        }
        return statsDClient;
    }
}

