/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.client;

import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.redis.client.RedisClient;
import com.gotocompany.depot.redis.client.response.RedisResponse;
import com.gotocompany.depot.redis.record.RedisRecord;
import com.gotocompany.depot.redis.ttl.RedisTtl;
import java.util.List;
import java.util.stream.Collectors;
import redis.clients.jedis.JedisCluster;

public class RedisClusterClient
implements RedisClient {
    private final Instrumentation instrumentation;
    private final RedisTtl redisTTL;
    private final JedisCluster jedisCluster;

    @Override
    public List<RedisResponse> send(List<RedisRecord> records) {
        return records.stream().map(record -> record.send(this.jedisCluster, this.redisTTL)).collect(Collectors.toList());
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
        this.instrumentation.logInfo("Closing Jedis client", new Object[0]);
        this.jedisCluster.close();
    }

    public RedisClusterClient(Instrumentation instrumentation, RedisTtl redisTTL, JedisCluster jedisCluster) {
        this.instrumentation = instrumentation;
        this.redisTTL = redisTTL;
        this.jedisCluster = jedisCluster;
    }
}

