/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.client.response;

import com.gotocompany.depot.redis.client.response.RedisResponse;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisException;

public class RedisStandaloneResponse
implements RedisResponse {
    private final Response response;
    private final Response ttlResponse;
    private final String command;
    private String message;
    private boolean failed = true;

    public RedisStandaloneResponse(String command, Response response, Response ttlResponse) {
        this.command = command;
        this.response = response;
        this.ttlResponse = ttlResponse;
    }

    public RedisStandaloneResponse process() {
        try {
            Object cmd = this.response.get();
            String ttl = this.ttlResponse != null ? ((Long)this.ttlResponse.get() == 0L ? "NOT UPDATED" : "UPDATED") : "NoOp";
            this.message = String.format("%s: %s, TTL: %s", this.command, cmd, ttl);
            this.failed = false;
        }
        catch (JedisException e) {
            this.message = e.getMessage();
            this.failed = true;
        }
        return this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }
}

