/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.record;

import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.response.RedisClusterResponse;
import com.gotocompany.depot.redis.client.response.RedisStandaloneResponse;
import com.gotocompany.depot.redis.ttl.RedisTtl;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Pipeline;

public class RedisRecord {
    private RedisEntry redisEntry;
    private final Long index;
    private final ErrorInfo errorInfo;
    private final String metadata;
    private final boolean valid;

    public RedisStandaloneResponse send(Pipeline jedisPipelined, RedisTtl redisTTL) {
        return this.redisEntry.send(jedisPipelined, redisTTL);
    }

    public RedisClusterResponse send(JedisCluster jedisCluster, RedisTtl redisTTL) {
        return this.redisEntry.send(jedisCluster, redisTTL);
    }

    public String toString() {
        return String.format("Metadata %s %s", this.metadata, this.redisEntry != null ? this.redisEntry.toString() : "NULL");
    }

    public RedisRecord(RedisEntry redisEntry, Long index, ErrorInfo errorInfo, String metadata, boolean valid) {
        this.redisEntry = redisEntry;
        this.index = index;
        this.errorInfo = errorInfo;
        this.metadata = metadata;
        this.valid = valid;
    }

    public Long getIndex() {
        return this.index;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public boolean isValid() {
        return this.valid;
    }
}

