/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.schema.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.gotocompany.depot.schema.LogicalType;
import com.gotocompany.depot.schema.Schema;
import com.gotocompany.depot.schema.SchemaField;
import com.gotocompany.depot.schema.proto.ProtoSchemaField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProtoSchema
implements Schema {
    private final Descriptors.Descriptor descriptor;
    private Map<String, ProtoSchemaField> fields;

    public ProtoSchema(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getFullName() {
        return this.descriptor.getFullName();
    }

    @Override
    public List<SchemaField> getFields() {
        this.initializeFields();
        return new ArrayList<SchemaField>(this.fields.values());
    }

    @Override
    public SchemaField getFieldByName(String name) {
        this.initializeFields();
        return this.fields.get(name);
    }

    @Override
    public LogicalType logicalType() {
        String fullName = this.descriptor.getFullName();
        if (Timestamp.getDescriptor().getFullName().equals(fullName)) {
            return LogicalType.TIMESTAMP;
        }
        if (Duration.getDescriptor().getFullName().equals(fullName)) {
            return LogicalType.DURATION;
        }
        if (Struct.getDescriptor().getFullName().equals(fullName)) {
            return LogicalType.STRUCT;
        }
        if (this.descriptor.getOptions().getMapEntry()) {
            return LogicalType.MAP;
        }
        return LogicalType.MESSAGE;
    }

    private void initializeFields() {
        if (this.fields == null) {
            this.fields = this.descriptor.getFields().stream().map(ProtoSchemaField::new).collect(Collectors.toMap(ProtoSchemaField::getName, Function.identity()));
        }
    }
}

