/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.gotocompany.stencil.exception.StencilRuntimeException;
import com.gotocompany.stencil.http.RemoteFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorMapBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorMapBuilder.class);

    public static Map<String, Descriptors.Descriptor> buildFrom(String url, RemoteFile remoteFile) {
        try {
            logger.info("fetching descriptors from {}", (Object)url);
            byte[] descriptorBin = remoteFile.fetch(url);
            logger.info("successfully fetched {}", (Object)url);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(descriptorBin);
            Map<String, Descriptors.Descriptor> newDescriptorsMap = DescriptorMapBuilder.buildFrom(inputStream);
            return newDescriptorsMap;
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new StencilRuntimeException(e);
        }
    }

    public static Map<String, Descriptors.Descriptor> buildFrom(InputStream stream) throws IOException, Descriptors.DescriptorValidationException {
        HashMap<String, Descriptors.Descriptor> descriptorMap = new HashMap<String, Descriptors.Descriptor>();
        ArrayList<Descriptors.FileDescriptor> fileDescriptors = new ArrayList<Descriptors.FileDescriptor>();
        DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)stream);
        for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
            fileDescriptors.add(Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdp, (Descriptors.FileDescriptor[])fileDescriptors.toArray(new Descriptors.FileDescriptor[0])));
        }
        fileDescriptors.forEach(fd -> {
            String javaPackage = fd.getOptions().getJavaPackage();
            String protoPackage = fd.getPackage();
            fd.getMessageTypes().stream().forEach(desc -> descriptorMap.putAll(DescriptorMapBuilder.getFlattenedDescriptors(desc, javaPackage, protoPackage, new HashMap<String, Descriptors.Descriptor>())));
        });
        return descriptorMap;
    }

    private static Map<String, Descriptors.Descriptor> getFlattenedDescriptors(Descriptors.Descriptor descriptor, String javaPackage, String protoPackage, Map<String, Descriptors.Descriptor> initialDescriptorMap) {
        String fullName = descriptor.getFullName();
        initialDescriptorMap.put(fullName, descriptor);
        if (!javaPackage.isEmpty() && !javaPackage.equals(protoPackage)) {
            initialDescriptorMap.put(DescriptorMapBuilder.getClassName(descriptor, protoPackage, javaPackage), descriptor);
        }
        descriptor.getNestedTypes().forEach(desc -> DescriptorMapBuilder.getFlattenedDescriptors(desc, javaPackage, protoPackage, initialDescriptorMap));
        return initialDescriptorMap;
    }

    private static String getClassName(Descriptors.Descriptor descriptor, String protoPackage, String javaPackage) {
        if (protoPackage.isEmpty()) {
            return String.format("%s.%s", javaPackage, descriptor.getFullName());
        }
        return descriptor.getFullName().replaceFirst(protoPackage, javaPackage);
    }
}

