/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil.cache;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.protobuf.Descriptors;
import com.gotocompany.stencil.SchemaUpdateListener;
import com.gotocompany.stencil.cache.SchemaRefreshStrategy;
import com.gotocompany.stencil.config.StencilConfig;
import com.gotocompany.stencil.http.RemoteFile;
import com.timgroup.statsd.StatsDClient;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCacheLoader
extends CacheLoader<String, Map<String, Descriptors.Descriptor>>
implements Closeable {
    private static final Integer DEFAULT_THREAD_POOL = 2;
    private final Logger logger = LoggerFactory.getLogger(SchemaCacheLoader.class);
    private StatsDClient statsDClient;
    private ExecutorService executor = Executors.newFixedThreadPool(DEFAULT_THREAD_POOL);
    private RemoteFile remoteFile;
    private SchemaUpdateListener protoUpdateListener;
    private boolean shouldRefresh;
    private SchemaRefreshStrategy refreshStrategy;

    public SchemaCacheLoader(RemoteFile remoteFile, StencilConfig config) {
        this.remoteFile = remoteFile;
        this.statsDClient = config.getStatsDClient();
        this.protoUpdateListener = config.getUpdateListener();
        this.shouldRefresh = config.getCacheAutoRefresh();
        this.refreshStrategy = config.getRefreshStrategy();
    }

    public Map<String, Descriptors.Descriptor> load(String key) {
        this.logger.info("loading stencil cache");
        return this.refreshStrategy.refresh(key, this.remoteFile, null);
    }

    public ListenableFuture<Map<String, Descriptors.Descriptor>> reload(String key, Map<String, Descriptors.Descriptor> prevDescriptor) {
        if (!this.shouldRefresh) {
            return Futures.immediateFuture(prevDescriptor);
        }
        this.logger.info("reloading the cache to get the new descriptors");
        ListenableFutureTask task = ListenableFutureTask.create(() -> {
            try {
                Map<String, Descriptors.Descriptor> newDescriptor = this.refreshStrategy.refresh(key, this.remoteFile, prevDescriptor);
                this.statsDClient.count("stencil.client.refresh,status=success", 1L, new String[0]);
                if (prevDescriptor != newDescriptor && this.protoUpdateListener != null) {
                    this.protoUpdateListener.onSchemaUpdate(newDescriptor);
                }
                return newDescriptor;
            }
            catch (Throwable e) {
                this.statsDClient.count("stencil.client.refresh,status=failed", 1L, new String[0]);
                this.logger.info("Exception on refreshing stencil descriptor", e);
                return prevDescriptor;
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    @Override
    public void close() throws IOException {
        this.remoteFile.close();
        this.executor.shutdown();
    }
}

